/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.web.ControllerNamingUtils;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

public class WebMvcRequestHandler
implements RequestHandler {
    private final HandlerMethodResolver methodResolver;
    private final RequestMappingInfo requestMapping;
    private final HandlerMethod handlerMethod;

    public WebMvcRequestHandler(HandlerMethodResolver methodResolver, RequestMappingInfo requestMapping, HandlerMethod handlerMethod) {
        this.methodResolver = methodResolver;
        this.requestMapping = requestMapping;
        this.handlerMethod = handlerMethod;
    }

    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }

    public RequestHandler combine(RequestHandler other) {
        return this;
    }

    public Class<?> declaringClass() {
        return this.handlerMethod.getBeanType();
    }

    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return null != AnnotationUtils.findAnnotation((Method)this.handlerMethod.getMethod(), annotation);
    }

    public PatternsRequestCondition getPatternsCondition() {
        return this.requestMapping.getPatternsCondition();
    }

    public String groupName() {
        return ControllerNamingUtils.controllerNameAsGroup(this.handlerMethod);
    }

    public String getName() {
        return this.handlerMethod.getMethod().getName();
    }

    public Set<RequestMethod> supportedMethods() {
        return this.requestMapping.getMethodsCondition().getMethods();
    }

    public Set<? extends MediaType> produces() {
        return this.requestMapping.getProducesCondition().getProducibleMediaTypes();
    }

    public Set<? extends MediaType> consumes() {
        return this.requestMapping.getConsumesCondition().getConsumableMediaTypes();
    }

    public Set<NameValueExpression<String>> headers() {
        return this.requestMapping.getHeadersCondition().getExpressions();
    }

    public Set<NameValueExpression<String>> params() {
        return this.requestMapping.getParamsCondition().getExpressions();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Method)this.handlerMethod.getMethod(), annotation));
    }

    public RequestHandlerKey key() {
        return new RequestHandlerKey(this.requestMapping.getPatternsCondition().getPatterns(), this.requestMapping.getMethodsCondition().getMethods(), this.requestMapping.getConsumesCondition().getConsumableMediaTypes(), this.requestMapping.getProducesCondition().getProducibleMediaTypes());
    }

    public List<ResolvedMethodParameter> getParameters() {
        return this.methodResolver.methodParameters(this.handlerMethod);
    }

    public ResolvedType getReturnType() {
        return this.methodResolver.methodReturnType(this.handlerMethod);
    }

    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Class)this.handlerMethod.getBeanType(), annotation));
    }

    public RequestMappingInfo getRequestMapping() {
        return this.requestMapping;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("WebMvcRequestHandler{");
        sb.append("key=").append(this.key());
        sb.append('}');
        return sb.toString();
    }
}

