/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.configuration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.util.Assert;

final class AutowireBeanFactoryObjectPostProcessor
implements ObjectPostProcessor<Object>,
DisposableBean,
SmartInitializingSingleton {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AutowireCapableBeanFactory autowireBeanFactory;
    private final List<DisposableBean> disposableBeans = new ArrayList<DisposableBean>();
    private final List<SmartInitializingSingleton> smartSingletons = new ArrayList<SmartInitializingSingleton>();

    public AutowireBeanFactoryObjectPostProcessor(AutowireCapableBeanFactory autowireBeanFactory) {
        Assert.notNull((Object)autowireBeanFactory, (String)"autowireBeanFactory cannot be null");
        this.autowireBeanFactory = autowireBeanFactory;
    }

    @Override
    public <T> T postProcess(T object) {
        if (object == null) {
            return null;
        }
        Object result = null;
        try {
            result = this.autowireBeanFactory.initializeBean(object, object.toString());
        }
        catch (RuntimeException e) {
            Class<?> type = object.getClass();
            throw new RuntimeException("Could not postProcess " + object + " of type " + type, e);
        }
        this.autowireBeanFactory.autowireBean(object);
        if (result instanceof DisposableBean) {
            this.disposableBeans.add((DisposableBean)result);
        }
        if (result instanceof SmartInitializingSingleton) {
            this.smartSingletons.add((SmartInitializingSingleton)result);
        }
        return (T)result;
    }

    public void afterSingletonsInstantiated() {
        for (SmartInitializingSingleton singleton : this.smartSingletons) {
            singleton.afterSingletonsInstantiated();
        }
    }

    public void destroy() throws Exception {
        for (DisposableBean disposable : this.disposableBeans) {
            try {
                disposable.destroy();
            }
            catch (Exception error) {
                this.logger.error((Object)error);
            }
        }
    }
}

