/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.dispatcher.sqlParser.sql;

import com.kingbase8.KBProperty;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.dispatcher.parser.ParseException;
import com.kingbase8.dispatcher.parser.statement.AbstractStatement;
import com.kingbase8.dispatcher.parser.statement.BeginStatement;
import com.kingbase8.dispatcher.parser.statement.EndStatement;
import com.kingbase8.dispatcher.parser.statement.OtherStatement;
import com.kingbase8.dispatcher.parser.statement.SelectStatement;
import com.kingbase8.dispatcher.parser.statement.SetStatement;
import com.kingbase8.dispatcher.parser.statement.Statement;
import com.kingbase8.dispatcher.parser.statement.TransactionStatement;
import com.kingbase8.util.LOGGER;
import com.kingbase8.util.Word;
import java.sql.SQLException;
import java.util.logging.Level;

public class SqlParser {
    private Statement statement;
    private String commandText = "";
    private String strategyValue;

    public String getStrategyValue() {
        return this.strategyValue;
    }

    public SqlParser(String sql, String strategyValue) {
        this.commandText = sql.trim().endsWith(";") ? sql.trim().substring(0, sql.trim().length() - 1) : sql.trim();
        this.strategyValue = strategyValue;
    }

    public Statement doParse(DispatchConnection dispatchConnection) throws ParseException {
        try {
            this.statement = this.parse(dispatchConnection);
            this.statement.setCommandText(this.commandText);
            return this.statement;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public Statement getParsedStatement() {
        return this.statement;
    }

    public final Statement parse(DispatchConnection dispatchConnection) throws SQLException {
        AbstractStatement statement = null;
        String blackSqlList = KBProperty.BLACKSQLLIST.get(dispatchConnection.m_props);
        if (blackSqlList != null) {
            String[] sqls;
            for (String sql : sqls = blackSqlList.split(";")) {
                if (!sql.equalsIgnoreCase(this.commandText)) continue;
                return new OtherStatement();
            }
        }
        if (this.commandText.toLowerCase().startsWith("begin")) {
            return new BeginStatement();
        }
        if (this.commandText.toLowerCase().startsWith("commit") || this.commandText.toLowerCase().startsWith("rollback") || this.commandText.toLowerCase().startsWith("end")) {
            return new EndStatement();
        }
        if (this.commandText.toLowerCase().startsWith("set") || this.commandText.toLowerCase().startsWith("reset")) {
            return new SetStatement();
        }
        if (this.commandText.toLowerCase().contains("nextval") || this.commandText.toLowerCase().contains("currval") || this.commandText.toLowerCase().contains("setval") || this.commandText.toLowerCase().contains("lastval")) {
            return new OtherStatement();
        }
        if (this.commandText.toLowerCase().startsWith("show")) {
            return new SelectStatement();
        }
        if (!dispatchConnection.getAutoCommit() && dispatchConnection.isHasUpdate()) {
            statement = new TransactionStatement();
        } else if ("2".equals(this.strategyValue)) {
            if (!dispatchConnection.getAutoCommit()) {
                int result = Word.parsing(this.commandText, dispatchConnection.whiteList, dispatchConnection.blackList, dispatchConnection.masterFunctionList, dispatchConnection.tempTables);
                if (result == 1) {
                    statement = new SelectStatement();
                } else if (result == 2) {
                    statement = new OtherStatement();
                } else {
                    statement = new TransactionStatement();
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "Enter transactional state from sql[" + this.commandText + "].");
                    }
                    dispatchConnection.setHasUpdate(true);
                }
            }
        } else if ("3".equals(this.strategyValue)) {
            statement = Word.parsing(this.commandText, dispatchConnection.whiteList, dispatchConnection.blackList, dispatchConnection.masterFunctionList, dispatchConnection.tempTables) == 1 ? new SelectStatement() : new OtherStatement();
        } else if (!dispatchConnection.getAutoCommit()) {
            statement = new TransactionStatement();
        }
        if (statement != null) {
            return statement;
        }
        statement = Word.parsing(this.commandText, dispatchConnection.whiteList, dispatchConnection.blackList, dispatchConnection.masterFunctionList, dispatchConnection.tempTables) == 1 ? new SelectStatement() : new OtherStatement();
        return statement;
    }
}

