/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.tracing;

import brave.Span;
import brave.propagation.TraceContextOrSamplingFlags;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.tracing.NoOpTracing;
import io.lettuce.core.tracing.TraceContext;
import io.lettuce.core.tracing.TraceContextProvider;
import io.lettuce.core.tracing.Tracer;
import io.lettuce.core.tracing.TracerProvider;
import io.lettuce.core.tracing.Tracing;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import reactor.core.publisher.Mono;
import zipkin2.Endpoint;

public class BraveTracing
implements Tracing {
    private final BraveTracer tracer;

    private BraveTracing(BraveTracer tracer) {
        LettuceAssert.notNull(tracer, "Tracer must not be null");
        this.tracer = tracer;
    }

    public static BraveTracing create(brave.Tracing tracing) {
        return new BraveTracing(new BraveTracer(tracing));
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public TracerProvider getTracerProvider() {
        return () -> this.tracer;
    }

    @Override
    public TraceContextProvider initialTraceContextProvider() {
        return BraveTraceContextProvider.INSTANCE;
    }

    @Override
    public Tracing.Endpoint createEndpoint(SocketAddress socketAddress) {
        Endpoint.Builder builder = Endpoint.newBuilder();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return new BraveEndpoint(builder.serviceName("redis").ip(inetSocketAddress.getAddress()).port(inetSocketAddress.getPort()).build());
        }
        return new BraveEndpoint(builder.serviceName("redis").build());
    }

    static enum BraveTraceContextProvider implements TraceContextProvider
    {
        INSTANCE;


        @Override
        public TraceContext getTraceContext() {
            Span span;
            brave.Tracer tracer = brave.Tracing.currentTracer();
            if (tracer != null && (span = tracer.currentSpan()) != null) {
                return new BraveTraceContext(span.context());
            }
            return null;
        }

        @Override
        public Mono<TraceContext> getTraceContextLater() {
            return Mono.subscriberContext().filter(it -> it.hasKey(Span.class) || it.hasKey(brave.propagation.TraceContext.class)).map(it -> {
                if (it.hasKey(Span.class)) {
                    return new BraveTraceContext(((Span)it.get(Span.class)).context());
                }
                return new BraveTraceContext((brave.propagation.TraceContext)it.get(brave.propagation.TraceContext.class));
            });
        }
    }

    public static class BraveTraceContext
    implements TraceContext {
        final brave.propagation.TraceContext traceContext;

        private BraveTraceContext(brave.propagation.TraceContext traceContext) {
            this.traceContext = traceContext;
        }

        public static BraveTraceContext create(brave.propagation.TraceContext traceContext) {
            return new BraveTraceContext(traceContext);
        }
    }

    public static class BraveEndpoint
    implements Tracing.Endpoint {
        final Endpoint endpoint;

        public BraveEndpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
        }
    }

    static class BraveSpan
    extends Tracer.Span {
        private final Span span;

        BraveSpan(Span span) {
            this.span = span;
        }

        @Override
        public BraveSpan start() {
            this.span.start();
            return this;
        }

        @Override
        public BraveSpan name(String name) {
            this.span.name(name);
            return this;
        }

        @Override
        public BraveSpan annotate(String value) {
            this.span.annotate(value);
            return this;
        }

        @Override
        public BraveSpan tag(String key, String value) {
            this.span.tag(key, value);
            return this;
        }

        @Override
        public BraveSpan error(Throwable throwable) {
            this.span.error(throwable);
            return this;
        }

        @Override
        public BraveSpan remoteEndpoint(Tracing.Endpoint endpoint) {
            this.span.remoteEndpoint(((BraveEndpoint)BraveEndpoint.class.cast((Object)endpoint)).endpoint);
            return this;
        }

        @Override
        public void finish() {
            this.span.finish();
        }

        public Span getSpan() {
            return this.span;
        }
    }

    static class BraveTracer
    extends Tracer {
        private final brave.Tracing tracing;

        public BraveTracer(brave.Tracing tracing) {
            this.tracing = tracing;
        }

        @Override
        public Tracer.Span nextSpan() {
            return this.postProcessSpan(this.tracing.tracer().nextSpan());
        }

        @Override
        public Tracer.Span nextSpan(TraceContext traceContext) {
            if (!(traceContext instanceof BraveTraceContext)) {
                return this.nextSpan();
            }
            BraveTraceContext braveTraceContext = (BraveTraceContext)BraveTraceContext.class.cast(traceContext);
            if (braveTraceContext.traceContext == null) {
                return this.nextSpan();
            }
            return this.postProcessSpan(this.tracing.tracer().nextSpan(TraceContextOrSamplingFlags.create((brave.propagation.TraceContext)braveTraceContext.traceContext)));
        }

        private Tracer.Span postProcessSpan(Span span) {
            if (span == null || span.isNoop()) {
                return NoOpTracing.NoOpSpan.INSTANCE;
            }
            return new BraveSpan(span.kind(Span.Kind.CLIENT));
        }
    }
}

