/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.controller;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.project.domain.PaTopic;
import com.ruoyi.project.service.IPaTopicService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/topic"})
public class PaTopicController
extends BaseController {
    @Autowired
    private IPaTopicService paTopicService;

    @PreAuthorize(value="@ss.hasPermi('project:info:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(PaTopic paTopic) {
        this.startPage();
        List<PaTopic> list = this.paTopicService.selectPaTopicList(paTopic);
        return this.getDataTable(list);
    }

    @GetMapping(value={"/listOptions"})
    public TableDataInfo listOptions(PaTopic paTopic) {
        this.startPage();
        List<PaTopic> list = this.paTopicService.selectPaTopicList(paTopic);
        ArrayList<SysDictData> resultList = new ArrayList<SysDictData>();
        for (PaTopic paTopic1 : list) {
            SysDictData data = new SysDictData();
            data.setDictCode(paTopic1.getId());
            data.setDictLabel(paTopic1.getName());
            data.setDictValue(paTopic1.getCode());
            resultList.add(data);
        }
        return this.getDataTable(resultList);
    }

    @PreAuthorize(value="@ss.hasPermi('project:info:list')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/export"})
    public AjaxResult export(PaTopic paTopic) {
        List<PaTopic> list = this.paTopicService.selectPaTopicList(paTopic);
        ExcelUtil util = new ExcelUtil(PaTopic.class);
        return util.exportExcel(list, "topic");
    }

    @PreAuthorize(value="@ss.hasPermi('project:info:list')")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)((Object)this.paTopicService.selectPaTopicById(id)));
    }

    @PreAuthorize(value="@ss.hasPermi('project:info:list')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody PaTopic paTopic) {
        this.paTopicService.insertPaTopicByMaxId(paTopic);
        AjaxResult ajax = AjaxResult.success();
        ajax.put((Object)"data", (Object)paTopic);
        return ajax;
    }

    @PreAuthorize(value="@ss.hasPermi('project:info:list')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PaTopic paTopic) {
        this.paTopicService.updatePaTopic(paTopic);
        AjaxResult ajax = AjaxResult.success();
        ajax.put((Object)"data", (Object)paTopic);
        return ajax;
    }

    @PreAuthorize(value="@ss.hasPermi('project:info:list')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.paTopicService.deletePaTopicByIds(ids));
    }
}

