/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.servlet;

import javax.ws.rs.ApplicationPath;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.boot.autoconfigure.web.servlet.JerseyApplicationPath;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class DefaultJerseyApplicationPath
implements JerseyApplicationPath {
    private final String applicationPath;
    private final ResourceConfig config;

    public DefaultJerseyApplicationPath(String applicationPath, ResourceConfig config) {
        this.applicationPath = applicationPath;
        this.config = config;
    }

    @Override
    public String getPath() {
        return this.resolveApplicationPath();
    }

    private String resolveApplicationPath() {
        if (StringUtils.hasLength((String)this.applicationPath)) {
            return this.applicationPath;
        }
        return DefaultJerseyApplicationPath.findApplicationPath((ApplicationPath)AnnotationUtils.findAnnotation(this.config.getApplication().getClass(), ApplicationPath.class));
    }

    private static String findApplicationPath(ApplicationPath annotation) {
        if (annotation == null) {
            return "/*";
        }
        return annotation.value();
    }
}

