/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.config.RuoYiConfig;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.DictUtils;
import com.ruoyi.common.utils.TextTransformUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.utils.poi.ExcelUtilPL;
import com.ruoyi.project.domain.PaDept;
import com.ruoyi.project.domain.PaInstruction;
import com.ruoyi.project.domain.PaSpecialSubject;
import com.ruoyi.project.domain.PaTopic;
import com.ruoyi.project.domain.ReportVo;
import com.ruoyi.project.service.IPaInstructionService;
import com.ruoyi.project.service.IPaProjectInfoService;
import com.ruoyi.project.service.IPaSpecialSubjectService;
import com.ruoyi.project.service.IPaTopicService;
import com.ruoyi.project.service.PaDeptService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/system/instruction"})
public class PaInstructionController
extends BaseController {
    @Autowired
    private IPaInstructionService paInstructionService;
    @Autowired
    private IPaProjectInfoService paProjectInfoService;
    @Autowired
    private PaDeptService paDeptService;
    @Autowired
    private IPaTopicService iPaTopicService;
    @Autowired
    private IPaSpecialSubjectService iPaSpecialSubjectService;

    @PreAuthorize(value="@ss.hasPermi('system:instruction:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(PaInstruction paInstruction) {
        this.startPage();
        List<PaInstruction> list = this.paInstructionService.selectPaInstructionList(paInstruction);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:instruction:export')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/export"})
    public AjaxResult export(PaInstruction paInstruction) {
        List<PaInstruction> list = this.paInstructionService.selectPaInstructionList(paInstruction);
        ExcelUtil util = new ExcelUtil(PaInstruction.class);
        return util.exportExcel(list, "instruction");
    }

    @PreAuthorize(value="@ss.hasPermi('system:instruction:query')")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)((Object)this.paInstructionService.selectPaInstructionById(id)));
    }

    @PreAuthorize(value="@ss.hasPermi('system:instruction:add')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody PaInstruction paInstruction) {
        return this.toAjax(this.paInstructionService.insertPaInstruction(paInstruction));
    }

    @PreAuthorize(value="@ss.hasPermi('system:instruction:edit')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PaInstruction paInstruction) {
        return this.toAjax(this.paInstructionService.updatePaInstruction(paInstruction));
    }

    @PreAuthorize(value="@ss.hasPermi('system:instruction:remove')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.paInstructionService.deletePaInstructionByIds(ids));
    }

    @GetMapping(value={"/importTemplate"})
    public AjaxResult importTemplate() {
        if (!RuoYiConfig.getIsTextTransform().booleanValue()) {
            return new ExcelUtil(PaTopic.class).importTemplateExcel("\u8bfe\u9898\u4f9d\u6258\u5355\u4f4d");
        }
        ExcelUtil util = new ExcelUtil(PaInstruction.class);
        return util.importTemplateExcel("\u9662\u58eb\u5efa\u8bae");
    }

    @PostMapping(value={"/importData"})
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception {
        if (!RuoYiConfig.getIsTextTransform().booleanValue()) {
            return this.updateTopic(file, updateSupport);
        }
        ExcelUtilPL util = new ExcelUtilPL(file.getInputStream());
        List list = util.importExcel("\u9662\u58eb\u5efa\u8bae", PaInstruction.class);
        Map<String, String> map_secret = this.getDictMap("pro_secret_level");
        StringBuffer titles = new StringBuffer();
        String msg = "";
        ArrayList<PaInstruction> importInfoList = new ArrayList<PaInstruction>();
        if (list.isEmpty()) {
            return AjaxResult.success((String)"\u6ca1\u6709\u9700\u5bfc\u5165\u7684\u6570\u636e\uff01");
        }
        for (PaInstruction p : list) {
            PaInstruction param = new PaInstruction();
            param.setNum(p.getNum());
            param.setTitle(p.getTitle());
            param.setUserName(p.getUserName());
            List<PaInstruction> temp = this.paInstructionService.selectPaInstructionList(param);
            if (temp.size() == 0) {
                if (StringUtils.isNotEmpty((CharSequence)p.getSecretLevel())) {
                    p.setSecretLevel(map_secret.get(p.getSecretLevel()));
                }
                if (StringUtils.isNotEmpty((CharSequence)p.getStatus())) {
                    if ("\u6709\u6279\u793a".equals(p.getStatus())) {
                        p.setStatus("1");
                    } else {
                        p.setStatus("0");
                    }
                }
                importInfoList.add(p);
                continue;
            }
            titles.append(p.getTitle() + "\u3001");
        }
        this.paInstructionService.importInstrunction(importInfoList);
        if (!"".equals(titles.toString())) {
            msg = "\n\u9662\u58eb\u5efa\u8bae\u6807\u9898" + titles.toString().substring(0, titles.toString().length() - 1) + "\u5185\u5bb9\u76f8\u540c\uff0c\u65e0\u6cd5\u518d\u6b21\u5f55\u5165";
        }
        int size = importInfoList.size();
        return AjaxResult.success((String)("\u6210\u529f\u5bfc\u5165" + size + "\u6761\u6570\u636e\uff01" + msg));
    }

    public AjaxResult importDataTest(MultipartFile file, boolean updateSupport) throws Exception {
        ExcelUtilPL util = new ExcelUtilPL(file.getInputStream());
        List deptList = util.importExcel("\u4f9d\u6258\u5355\u4f4d", PaDept.class);
        List toipList = util.importExcel("\u8bfe\u9898\u4f9d\u6258\u5355\u4f4d", ReportVo.class);
        List speList = util.importExcel("\u4e13\u9898\u4f9d\u6258\u5355\u4f4d", ReportVo.class);
        List newToipList = util.importExcel("\u65b0\u8bfe\u9898\u4f9d\u6258\u5355\u4f4d", ReportVo.class);
        String msg = "";
        StringBuffer titles = new StringBuffer();
        ArrayList<PaDept> inportPadeptList = new ArrayList<PaDept>();
        StringBuffer deptIds = new StringBuffer();
        for (PaDept paDept : deptList) {
            if (this.paDeptService.queryById(paDept.getId()) == null) {
                inportPadeptList.add(paDept);
                continue;
            }
            deptIds.append(paDept.getId() + "\u3001");
        }
        toipList.forEach(reportVo -> {
            List<PaTopic> paTopics = this.iPaTopicService.selectPaTopicByCode(reportVo.getCode());
            if (!paTopics.isEmpty()) {
                paTopics.forEach(paTopic -> {
                    paTopic.setRelyId(reportVo.getDeptId());
                    this.iPaTopicService.updatePaTopic((PaTopic)((Object)((Object)paTopic)));
                });
            }
        });
        newToipList.forEach(reportVo -> {
            List<PaTopic> paTopics = this.iPaTopicService.selectPaTopicByCode(reportVo.getCode());
            if (!paTopics.isEmpty()) {
                paTopics.forEach(paTopic -> {
                    paTopic.setRelyId(reportVo.getDeptId());
                    this.iPaTopicService.updatePaTopic((PaTopic)((Object)((Object)paTopic)));
                });
            }
        });
        speList.forEach(reportVo -> {
            List<PaSpecialSubject> paSpecialSubjects = this.iPaSpecialSubjectService.selectPaSpecialSubjectByCode(reportVo.getCode());
            if (!paSpecialSubjects.isEmpty()) {
                paSpecialSubjects.forEach(paSpecialSubject -> {
                    paSpecialSubject.setRelyId(reportVo.getDeptId());
                    this.iPaSpecialSubjectService.updatePaSpecialSubject((PaSpecialSubject)((Object)((Object)paSpecialSubject)));
                });
            }
        });
        if (!"".equals(titles.toString())) {
            msg = "\n\u9662\u58eb\u5efa\u8bae\u6807\u9898" + titles.toString().substring(0, titles.toString().length() - 1) + "\u5185\u5bb9\u76f8\u540c\uff0c\u65e0\u6cd5\u518d\u6b21\u5f55\u5165";
        }
        int size = 0;
        if (!inportPadeptList.isEmpty()) {
            size = this.paDeptService.insertBatch(inportPadeptList);
        }
        return AjaxResult.success((String)("\u6210\u529f\u5bfc\u5165" + size + "\u6761\u6570\u636e\uff01" + msg));
    }

    public AjaxResult updateTopic(MultipartFile file, boolean updateSupport) throws Exception {
        ExcelUtilPL util = new ExcelUtilPL(file.getInputStream());
        int size = 0;
        StringBuffer sb = new StringBuffer();
        List toipList = util.importExcel("\u8bfe\u9898\u4f9d\u6258\u5355\u4f4d", PaTopic.class);
        for (PaTopic paTopic : toipList) {
            List<PaTopic> paTopics = this.iPaTopicService.selectPaTopicByCode(paTopic.getCode());
            for (PaTopic topic : paTopics) {
                topic.setUserName(paTopic.getUserName());
                this.iPaTopicService.updatePaTopic(topic);
                ++size;
                sb.append(topic.getCode() + "/");
            }
        }
        return AjaxResult.success((String)("\u6210\u529f\u5bfc\u5165" + size + "\u6761\u6570\u636e\uff01" + sb));
    }

    private Map<String, String> getDictMap(String type) {
        List datas_secret = DictUtils.getDictCache((String)type);
        HashMap<String, String> map_secret = new HashMap<String, String>();
        for (SysDictData d : datas_secret) {
            map_secret.put(d.getDictLabel(), d.getDictValue());
        }
        return map_secret;
    }

    @GetMapping(value={"/leftData1"})
    public AjaxResult leftData1(PaInstruction paInstruction) {
        List<Map<String, Integer>> resultMap = this.paInstructionService.selectCountByStatus(paInstruction);
        JSONArray youArray = new JSONArray();
        JSONArray wuArray = new JSONArray();
        JSONArray yearArray = new JSONArray();
        for (int i = resultMap.size() - 1; i >= 0; --i) {
            youArray.add((Object)resultMap.get(i).get(this.tranformStr("YOUNUM")));
            wuArray.add((Object)resultMap.get(i).get(this.tranformStr("WUNUM")));
            yearArray.add((Object)resultMap.get(i).get(this.tranformStr("YEAR")));
        }
        HashMap<String, JSONArray> result = new HashMap<String, JSONArray>();
        result.put("youArray", youArray);
        result.put("wuArray", wuArray);
        result.put("yearArray", yearArray);
        return AjaxResult.success(result);
    }

    @GetMapping(value={"/center2Data"})
    public AjaxResult center2Data(PaInstruction paInstruction) {
        List<Map<String, Object>> resultMap = this.paInstructionService.selectNumGroupDept(paInstruction);
        JSONArray legendData = new JSONArray();
        JSONArray pieData = new JSONArray();
        for (Map<String, Object> map : resultMap) {
            legendData.add((Object)map.get(this.tranformStr("DEPTNAME")).toString());
            JSONObject o = new JSONObject();
            o.put("value", (Object)map.get(this.tranformStr("DEPTNUM")).toString());
            o.put("name", (Object)map.get(this.tranformStr("DEPTNAME")).toString());
            pieData.add((Object)o);
        }
        HashMap<String, JSONArray> result = new HashMap<String, JSONArray>();
        result.put("lgData", legendData);
        result.put("pieData", pieData);
        return AjaxResult.success(result);
    }

    @GetMapping(value={"/center8Data"})
    public AjaxResult center8Data(PaInstruction paInstruction) {
        List<Map<String, Integer>> resultMap = this.paInstructionService.selectCountByName(paInstruction);
        JSONArray yAxisArray = new JSONArray();
        JSONArray xAxisArray = new JSONArray();
        for (int i = resultMap.size() - 1; i >= 0; --i) {
            xAxisArray.add((Object)resultMap.get(i).get(this.tranformStr("pnum")));
            yAxisArray.add((Object)resultMap.get(i).get(this.tranformStr("username")));
        }
        HashMap<String, JSONArray> result = new HashMap<String, JSONArray>();
        result.put("xAxisArray", xAxisArray);
        result.put("yAxisArray", yAxisArray);
        return AjaxResult.success(result);
    }

    private String tranformStr(String str) {
        return TextTransformUtils.transformStr((String)str);
    }
}

