/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.controller;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.project.domain.PaAttachment;
import com.ruoyi.project.service.IPaAttachmentService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/attachment"})
public class PaAttachmentController
extends BaseController {
    @Autowired
    private IPaAttachmentService paAttachmentService;

    @PreAuthorize(value="@ss.hasPermi('project:info:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(PaAttachment paAttachment) {
        this.startPage();
        List<PaAttachment> list = this.paAttachmentService.selectPaAttachmentList(paAttachment);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('project:info:list')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/export"})
    public AjaxResult export(PaAttachment paAttachment) {
        List<PaAttachment> list = this.paAttachmentService.selectPaAttachmentList(paAttachment);
        ExcelUtil util = new ExcelUtil(PaAttachment.class);
        return util.exportExcel(list, "attachment");
    }

    @PreAuthorize(value="@ss.hasPermi('project:info:list')")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)((Object)this.paAttachmentService.selectPaAttachmentById(id)));
    }

    @PreAuthorize(value="@ss.hasPermi('project:info:list')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody PaAttachment paAttachment) {
        return this.toAjax(this.paAttachmentService.insertPaAttachment(paAttachment));
    }

    @PreAuthorize(value="@ss.hasPermi('project:info:list')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PaAttachment paAttachment) {
        return this.toAjax(this.paAttachmentService.updatePaAttachment(paAttachment));
    }

    @PreAuthorize(value="@ss.hasPermi('project:info:list')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.paAttachmentService.deletePaAttachmentByIds(ids));
    }
}

