/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.mock.http.MockHttpOutputMessage;
import org.springframework.util.Assert;

public class MockClientHttpRequest
extends MockHttpOutputMessage
implements ClientHttpRequest {
    private HttpMethod httpMethod;
    private URI uri;
    @Nullable
    private ClientHttpResponse clientHttpResponse;
    private boolean executed = false;

    public MockClientHttpRequest() {
        this.httpMethod = HttpMethod.GET;
        try {
            this.uri = new URI("/");
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public MockClientHttpRequest(HttpMethod httpMethod, URI uri) {
        this.httpMethod = httpMethod;
        this.uri = uri;
    }

    public void setMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public String getMethodValue() {
        return this.httpMethod.name();
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setResponse(ClientHttpResponse clientHttpResponse) {
        this.clientHttpResponse = clientHttpResponse;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public final ClientHttpResponse execute() throws IOException {
        this.executed = true;
        return this.executeInternal();
    }

    protected ClientHttpResponse executeInternal() throws IOException {
        Assert.state((this.clientHttpResponse != null ? 1 : 0) != 0, (String)"No ClientHttpResponse");
        return this.clientHttpResponse;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.httpMethod);
        sb.append(" ").append(this.uri);
        if (!this.getHeaders().isEmpty()) {
            sb.append(", headers: ").append(this.getHeaders());
        }
        if (sb.length() == 0) {
            sb.append("Not yet initialized");
        }
        return sb.toString();
    }
}

