/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.List;
import java.util.Map;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.lang.Nullable;

public interface GeoOperations<K, M> {
    @Nullable
    public Long add(K var1, Point var2, M var3);

    @Deprecated
    @Nullable
    default public Long geoAdd(K key, Point point, M member) {
        return this.add(key, point, member);
    }

    @Nullable
    public Long add(K var1, RedisGeoCommands.GeoLocation<M> var2);

    @Deprecated
    @Nullable
    default public Long geoAdd(K key, RedisGeoCommands.GeoLocation<M> location) {
        return this.add(key, location);
    }

    @Nullable
    public Long add(K var1, Map<M, Point> var2);

    @Deprecated
    @Nullable
    default public Long geoAdd(K key, Map<M, Point> memberCoordinateMap) {
        return this.add(key, memberCoordinateMap);
    }

    @Nullable
    public Long add(K var1, Iterable<RedisGeoCommands.GeoLocation<M>> var2);

    @Deprecated
    @Nullable
    default public Long geoAdd(K key, Iterable<RedisGeoCommands.GeoLocation<M>> locations) {
        return this.add(key, locations);
    }

    @Nullable
    public Distance distance(K var1, M var2, M var3);

    @Deprecated
    @Nullable
    default public Distance geoDist(K key, M member1, M member2) {
        return this.distance(key, member1, member2);
    }

    @Nullable
    public Distance distance(K var1, M var2, M var3, Metric var4);

    @Deprecated
    @Nullable
    default public Distance geoDist(K key, M member1, M member2, Metric metric) {
        return this.distance(key, member1, member2, metric);
    }

    @Nullable
    public List<String> hash(K var1, M ... var2);

    @Deprecated
    @Nullable
    default public List<String> geoHash(K key, M ... members) {
        return this.hash(key, members);
    }

    @Nullable
    public List<Point> position(K var1, M ... var2);

    @Deprecated
    @Nullable
    default public List<Point> geoPos(K key, M ... members) {
        return this.position(key, members);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K var1, Circle var2);

    @Deprecated
    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadius(K key, Circle within) {
        return this.radius(key, within);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K var1, Circle var2, RedisGeoCommands.GeoRadiusCommandArgs var3);

    @Deprecated
    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadius(K key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.radius(key, within, args);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K var1, M var2, double var3);

    @Deprecated
    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadiusByMember(K key, M member, double radius) {
        return this.radius(key, member, radius);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K var1, M var2, Distance var3);

    @Deprecated
    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadiusByMember(K key, M member, Distance distance) {
        return this.radius(key, member, distance);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K var1, M var2, Distance var3, RedisGeoCommands.GeoRadiusCommandArgs var4);

    @Deprecated
    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadiusByMember(K key, M member, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.radius(key, member, distance, args);
    }

    @Nullable
    public Long remove(K var1, M ... var2);

    @Deprecated
    @Nullable
    default public Long geoRemove(K key, M ... members) {
        return this.remove(key, members);
    }
}

