/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.data.redis.core.RedisOperations;

abstract class DefaultBoundKeyOperations<K>
implements BoundKeyOperations<K> {
    private K key;
    private final RedisOperations<K, ?> ops;

    DefaultBoundKeyOperations(K key, RedisOperations<K, ?> operations) {
        this.key = key;
        this.ops = operations;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public Boolean expire(long timeout, TimeUnit unit) {
        return this.ops.expire(this.key, timeout, unit);
    }

    @Override
    public Boolean expireAt(Date date) {
        return this.ops.expireAt(this.key, date);
    }

    @Override
    public Long getExpire() {
        return this.ops.getExpire(this.key);
    }

    @Override
    public Boolean persist() {
        return this.ops.persist(this.key);
    }

    @Override
    public void rename(K newKey) {
        if (this.ops.hasKey(this.key).booleanValue()) {
            this.ops.rename(this.key, newKey);
        }
        this.key = newKey;
    }
}

