/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.controller;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.utils.poi.ExcelUtilPL;
import com.ruoyi.project.domain.PaResult;
import com.ruoyi.project.service.IPaResultService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/system/result"})
public class PaResultController
extends BaseController {
    @Autowired
    private IPaResultService paResultService;

    @PreAuthorize(value="@ss.hasPermi('system:result:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(PaResult paResult) {
        this.startPage();
        List<PaResult> list = this.paResultService.selectPaResultList(paResult);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:result:export')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/export"})
    public AjaxResult export(PaResult paResult) {
        List<PaResult> list = this.paResultService.selectPaResultList(paResult);
        ExcelUtil util = new ExcelUtil(PaResult.class);
        return util.exportExcel(list, "result");
    }

    @GetMapping(value={"/importTemplate"})
    public AjaxResult importTemplate() {
        ExcelUtil util = new ExcelUtil(PaResult.class);
        return util.importTemplateExcel("\u767e\u9879\u6210\u679c");
    }

    @PostMapping(value={"/importData"})
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception {
        ExcelUtilPL util = new ExcelUtilPL(file.getInputStream());
        List list = util.importExcel("\u767e\u9879\u6210\u679c", PaResult.class);
        if (list.isEmpty()) {
            return AjaxResult.success((String)"\u6ca1\u6709\u9700\u8981\u5bfc\u5165\u7684\u6570\u636e");
        }
        StringBuffer titles = new StringBuffer();
        String msg = "";
        ArrayList<PaResult> imports = new ArrayList<PaResult>();
        for (PaResult result : list) {
            PaResult param = new PaResult();
            param.setName(result.getName());
            List<PaResult> paResults = this.paResultService.selectPaResultList(param);
            if (paResults.size() == 0) {
                imports.add(result);
            } else {
                titles.append("\u6539\u9879\u76ee\u5df2\u5b58\u5728");
            }
            System.err.println((Object)result);
        }
        this.paResultService.importInstrunction(imports);
        if (!"".equals(titles.toString())) {
            msg = "\n\u9662\u58eb\u5efa\u8bae\u6807\u9898" + titles.toString().substring(0, titles.toString().length() - 1) + "\u5185\u5bb9\u76f8\u540c\uff0c\u65e0\u6cd5\u518d\u6b21\u5f55\u5165";
        }
        int size = imports.size();
        return AjaxResult.success((String)("\u6210\u529f\u5bfc\u5165" + size + "\u6761\u6570\u636e\uff01" + msg));
    }

    @PreAuthorize(value="@ss.hasPermi('system:result:query')")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)((Object)this.paResultService.selectPaResultById(id)));
    }

    @PreAuthorize(value="@ss.hasPermi('system:result:add')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody PaResult paResult) {
        return this.toAjax(this.paResultService.insertPaResult(paResult));
    }

    @PreAuthorize(value="@ss.hasPermi('system:result:edit')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PaResult paResult) {
        return this.toAjax(this.paResultService.updatePaResult(paResult));
    }

    @PreAuthorize(value="@ss.hasPermi('system:result:remove')")
    @Log(title="\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.paResultService.deletePaResultByIds(ids));
    }
}

