/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.service.impl;

import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.project.domain.PaTopic;
import com.ruoyi.project.mapper.PaTopicMapper;
import com.ruoyi.project.service.IPaTopicService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaTopicServiceImpl
implements IPaTopicService {
    @Autowired
    private PaTopicMapper paTopicMapper;

    @Override
    public PaTopic selectPaTopicById(Long id) {
        return this.paTopicMapper.selectPaTopicById(id);
    }

    @Override
    public List<PaTopic> selectPaTopicList(PaTopic paTopic) {
        return this.paTopicMapper.selectPaTopicList(paTopic);
    }

    @Override
    public int insertPaTopic(PaTopic paTopic) {
        paTopic.setCreateTime(DateUtils.getNowDate());
        return this.paTopicMapper.insertPaTopic(paTopic);
    }

    @Override
    public int updatePaTopic(PaTopic paTopic) {
        paTopic.setUpdateTime(DateUtils.getNowDate());
        return this.paTopicMapper.updatePaTopic(paTopic);
    }

    @Override
    public int deletePaTopicByIds(Long[] ids) {
        return this.paTopicMapper.deletePaTopicByIds(ids);
    }

    @Override
    public int deletePaTopicById(Long id) {
        return this.paTopicMapper.deletePaTopicById(id);
    }

    @Override
    public int importProject(List<PaTopic> importTopicList) {
        for (PaTopic p : importTopicList) {
            this.insertPaTopic(p);
        }
        return importTopicList.size();
    }

    @Override
    public int importAndModifyProject(List<PaTopic> importTopicList) {
        for (PaTopic p : importTopicList) {
            this.updatePaTopic(p);
        }
        return importTopicList.size();
    }

    @Override
    public int insertPaTopicByMaxId(PaTopic paTopic) {
        Long maxId = this.paTopicMapper.selectMaxId();
        if (maxId < 100000000L) {
            paTopic.setId(100000000L);
        } else {
            paTopic.setId(maxId + 1L);
        }
        return this.insertPaTopic(paTopic);
    }

    @Override
    public List<PaTopic> selectPaTopicByCode(String code) {
        return this.paTopicMapper.selectPaTopicByCode(code);
    }
}

