/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.project.service.impl;

import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.project.domain.PaParticipants;
import com.ruoyi.project.mapper.PaParticipantsMapper;
import com.ruoyi.project.service.IPaParticipantsService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaParticipantsServiceImpl
implements IPaParticipantsService {
    @Autowired
    private PaParticipantsMapper paParticipantsMapper;

    @Override
    public PaParticipants selectPaParticipantsById(Long id) {
        return this.paParticipantsMapper.selectPaParticipantsById(id);
    }

    @Override
    public List<PaParticipants> selectPaParticipantsList(PaParticipants paParticipants) {
        return this.paParticipantsMapper.selectPaParticipantsList(paParticipants);
    }

    @Override
    public int insertPaParticipants(PaParticipants paParticipants) {
        paParticipants.setCreateTime(DateUtils.getNowDate());
        return this.paParticipantsMapper.insertPaParticipants(paParticipants);
    }

    @Override
    public int updatePaParticipants(PaParticipants paParticipants) {
        paParticipants.setUpdateTime(DateUtils.getNowDate());
        return this.paParticipantsMapper.updatePaParticipants(paParticipants);
    }

    @Override
    public int deletePaParticipantsByIds(Long[] ids) {
        return this.paParticipantsMapper.deletePaParticipantsByIds(ids);
    }

    @Override
    public int deletePaParticipantsById(Long id) {
        return this.paParticipantsMapper.deletePaParticipantsById(id);
    }

    @Override
    public int importProject(List<PaParticipants> importPeopleList) {
        for (PaParticipants p : importPeopleList) {
            if (this.selectPaParticipantsById(p.getId()) != null) continue;
            this.insertPaParticipants(p);
        }
        return importPeopleList.size();
    }

    @Override
    public int importAndModifyProject(List<PaParticipants> importPeopleList) {
        for (PaParticipants p : importPeopleList) {
            this.updatePaParticipants(p);
        }
        return importPeopleList.size();
    }

    @Override
    public int insertPaParticipantsByMaxId(PaParticipants paParticipants) {
        Long maxId = this.paParticipantsMapper.selectMaxId();
        if (maxId < 100000000L) {
            paParticipants.setId(100000000L);
        } else {
            paParticipants.setId(maxId + 1L);
        }
        return this.insertPaParticipants(paParticipants);
    }
}

