/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxContextStart;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

final class MonoSubscriberContext<T>
extends MonoOperator<T, T>
implements Fuseable {
    final Function<Context, Context> doOnContext;

    MonoSubscriberContext(Mono<? extends T> source, Function<Context, Context> doOnContext) {
        super(source);
        this.doOnContext = Objects.requireNonNull(doOnContext, "doOnContext");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Context c;
        try {
            c = this.doOnContext.apply(actual.currentContext());
        }
        catch (Throwable t) {
            Operators.error(actual, Operators.onOperatorError(t, actual.currentContext()));
            return;
        }
        this.source.subscribe(new FluxContextStart.ContextStartSubscriber<T>(actual, c));
    }
}

