/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.plugin.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.plugin.core.Plugin;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;

public abstract class PluginRegistrySupport<T extends Plugin<S>, S>
implements PluginRegistry<T, S>,
Iterable<T> {
    private List<T> plugins;
    private boolean initialized;

    public PluginRegistrySupport(List<? extends T> plugins) {
        Assert.notNull(plugins);
        this.plugins = plugins == null ? new ArrayList() : plugins;
        this.initialized = false;
    }

    @Override
    public List<T> getPlugins() {
        if (!this.initialized) {
            this.plugins = this.initialize(this.plugins);
            this.initialized = true;
        }
        return this.plugins;
    }

    protected synchronized List<T> initialize(List<T> plugins) {
        Assert.notNull(plugins);
        ArrayList<Plugin> result = new ArrayList<Plugin>();
        for (Plugin plugin : this.plugins) {
            if (plugin == null) continue;
            result.add(plugin);
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getPlugins().iterator();
    }
}

