/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.derived;

import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.terracotta.statistics.derived.OperationResultFilter;
import org.terracotta.statistics.observer.ChainedEventObserver;

public class OperationResultSampler<T extends Enum<T>>
extends OperationResultFilter<T> {
    private final int ceiling;

    public OperationResultSampler(Set<T> targets, double sampling, ChainedEventObserver ... observers) {
        super(targets, observers);
        if (sampling > 1.0 || sampling < 0.0) {
            throw new IllegalArgumentException("Sampling must be between 0.0 and 1.0");
        }
        this.ceiling = (int)(2.147483647E9 * sampling);
    }

    @Override
    public void end(long time, long latency, T result) {
        if (!this.derivedStatistics.isEmpty() && this.targets.contains(result) && this.sample()) {
            for (ChainedEventObserver derived : this.derivedStatistics) {
                derived.event(time, latency);
            }
        }
    }

    private boolean sample() {
        return this.ceiling == Integer.MAX_VALUE || ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE) < this.ceiling;
    }

    public int getCeiling() {
        return this.ceiling;
    }
}

