/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceClassUtils;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

public class KqueueProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(KqueueProvider.class);
    private static final String KQUEUE_ENABLED_KEY = "io.lettuce.core.kqueue";
    private static final boolean KQUEUE_ENABLED = Boolean.parseBoolean(SystemPropertyUtil.get((String)"io.lettuce.core.kqueue", (String)"true"));
    private static final boolean KQUEUE_AVAILABLE;
    private static final KqueueResources KQUEUE_RESOURCES;

    public static boolean isAvailable() {
        return KQUEUE_AVAILABLE && KQUEUE_ENABLED;
    }

    static void checkForKqueueLibrary() {
        LettuceAssert.assertState(KQUEUE_ENABLED, String.format("kqueue use is disabled via System properties (%s)", KQUEUE_ENABLED_KEY));
        LettuceAssert.assertState(KqueueProvider.isAvailable(), "netty-transport-native-kqueue is not available. Make sure netty-transport-native-kqueue library on the class path and supported by your operating system.");
    }

    public static boolean isEventLoopGroup(Class<? extends EventExecutorGroup> type) {
        return KQUEUE_RESOURCES.isEventLoopGroup(type);
    }

    public static EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
        return KQUEUE_RESOURCES.newEventLoopGroup(nThreads, threadFactory);
    }

    static Class<? extends Channel> domainSocketChannelClass() {
        return KQUEUE_RESOURCES.domainSocketChannelClass();
    }

    static Class<? extends Channel> socketChannelClass() {
        return KQUEUE_RESOURCES.socketChannelClass();
    }

    static Class<? extends EventLoopGroup> eventLoopGroupClass() {
        return KQUEUE_RESOURCES.eventLoopGroupClass();
    }

    static SocketAddress newSocketAddress(String socketPath) {
        return KQUEUE_RESOURCES.newSocketAddress(socketPath);
    }

    static <T> Class<T> forName(String name) {
        try {
            return LettuceClassUtils.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(name);
        }
    }

    static {
        boolean availability = false;
        try {
            Class<?> kqueue = Class.forName("io.netty.channel.kqueue.KQueue");
            Method isAvailable = kqueue.getDeclaredMethod("isAvailable", new Class[0]);
            availability = (Boolean)isAvailable.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        KQUEUE_AVAILABLE = availability;
        if (KQUEUE_AVAILABLE) {
            logger.info("Starting with kqueue library");
            KQUEUE_RESOURCES = AvailableKqueueResources.INSTANCE;
        } else {
            logger.info("Starting without optional kqueue library");
            KQUEUE_RESOURCES = UnavailableKqueueResources.INSTANCE;
        }
    }

    static enum AvailableKqueueResources implements KqueueResources
    {
        INSTANCE;


        @Override
        public boolean isEventLoopGroup(Class<? extends EventExecutorGroup> type) {
            LettuceAssert.notNull(type, "EventLoopGroup type must not be null");
            return type.equals(this.eventLoopGroupClass());
        }

        @Override
        public EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
            KqueueProvider.checkForKqueueLibrary();
            try {
                Constructor<? extends EventLoopGroup> constructor = this.eventLoopGroupClass().getDeclaredConstructor(Integer.TYPE, ThreadFactory.class);
                return constructor.newInstance(nThreads, threadFactory);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Cannot create KQueueEventLoopGroup");
            }
        }

        @Override
        public Class<? extends Channel> domainSocketChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return KqueueProvider.forName("io.netty.channel.kqueue.KQueueDomainSocketChannel");
        }

        @Override
        public Class<? extends Channel> socketChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return KqueueProvider.forName("io.netty.channel.kqueue.KQueueSocketChannel");
        }

        @Override
        public Class<? extends EventLoopGroup> eventLoopGroupClass() {
            KqueueProvider.checkForKqueueLibrary();
            return KqueueProvider.forName("io.netty.channel.kqueue.KQueueEventLoopGroup");
        }

        @Override
        public SocketAddress newSocketAddress(String socketPath) {
            KqueueProvider.checkForKqueueLibrary();
            return new DomainSocketAddress(socketPath);
        }
    }

    static enum UnavailableKqueueResources implements KqueueResources
    {
        INSTANCE;


        @Override
        public Class<? extends Channel> domainSocketChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }

        @Override
        public Class<? extends EventLoopGroup> eventLoopGroupClass() {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }

        @Override
        public boolean isEventLoopGroup(Class<? extends EventExecutorGroup> type) {
            KqueueProvider.checkForKqueueLibrary();
            return false;
        }

        @Override
        public EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }

        @Override
        public SocketAddress newSocketAddress(String socketPath) {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }

        @Override
        public Class<? extends Channel> socketChannelClass() {
            KqueueProvider.checkForKqueueLibrary();
            return null;
        }
    }

    public static interface KqueueResources {
        public boolean isEventLoopGroup(Class<? extends EventExecutorGroup> var1);

        public EventLoopGroup newEventLoopGroup(int var1, ThreadFactory var2);

        public Class<? extends Channel> domainSocketChannelClass();

        public Class<? extends Channel> socketChannelClass();

        public Class<? extends EventLoopGroup> eventLoopGroupClass();

        public SocketAddress newSocketAddress(String var1);
    }
}

