/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.archives.controller;

import com.ruoyi.archives.domain.FileUploadList;
import com.ruoyi.archives.service.IFileUploadListService;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/archives/fileUploadList"})
public class FileUploadListController
extends BaseController {
    @Autowired
    private IFileUploadListService fileUploadListService;

    @PreAuthorize(value="@ss.hasPermi('archives:fileUploadList:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(FileUploadList fileUploadList) {
        this.startPage();
        List<FileUploadList> list = this.fileUploadListService.selectFileUploadListList(fileUploadList);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('archives:fileUploadList:export')")
    @Log(title="\u6587\u4ef6\u4e0a\u4f20\u5217\u8868", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/export"})
    public AjaxResult export(FileUploadList fileUploadList) {
        List<FileUploadList> list = this.fileUploadListService.selectFileUploadListList(fileUploadList);
        ExcelUtil util = new ExcelUtil(FileUploadList.class);
        return util.exportExcel(list, "fileUploadList");
    }

    @PreAuthorize(value="@ss.hasPermi('archives:fileUploadList:query')")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.fileUploadListService.selectFileUploadListById(id));
    }

    @PreAuthorize(value="@ss.hasPermi('archives:fileUploadList:add')")
    @Log(title="\u6587\u4ef6\u4e0a\u4f20\u5217\u8868", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody FileUploadList fileUploadList) {
        return this.toAjax(this.fileUploadListService.insertFileUploadList(fileUploadList));
    }

    @PreAuthorize(value="@ss.hasPermi('archives:fileUploadList:edit')")
    @Log(title="\u6587\u4ef6\u4e0a\u4f20\u5217\u8868", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody FileUploadList fileUploadList) {
        return this.toAjax(this.fileUploadListService.updateFileUploadList(fileUploadList));
    }

    @PreAuthorize(value="@ss.hasPermi('archives:fileUploadList:remove')")
    @Log(title="\u6587\u4ef6\u4e0a\u4f20\u5217\u8868", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.fileUploadListService.deleteFileUploadListByIds(ids));
    }
}

