/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.quartz.controller;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.exception.job.TaskException;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.quartz.domain.SysJob;
import com.ruoyi.quartz.service.ISysJobService;
import com.ruoyi.quartz.util.CronUtils;
import java.util.List;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor/job"})
public class SysJobController
extends BaseController {
    @Autowired
    private ISysJobService jobService;

    @PreAuthorize(value="@ss.hasPermi('monitor:job:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysJob sysJob) {
        this.startPage();
        List<SysJob> list = this.jobService.selectJobList(sysJob);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('monitor:job:export')")
    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/export"})
    public AjaxResult export(SysJob sysJob) {
        List<SysJob> list = this.jobService.selectJobList(sysJob);
        ExcelUtil util = new ExcelUtil(SysJob.class);
        return util.exportExcel(list, "\u5b9a\u65f6\u4efb\u52a1");
    }

    @PreAuthorize(value="@ss.hasPermi('monitor:job:query')")
    @GetMapping(value={"/{jobId}"})
    public AjaxResult getInfo(@PathVariable(value="jobId") Long jobId) {
        return AjaxResult.success((Object)this.jobService.selectJobById(jobId));
    }

    @PreAuthorize(value="@ss.hasPermi('monitor:job:add')")
    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysJob sysJob) throws SchedulerException, TaskException {
        if (!CronUtils.isValid(sysJob.getCronExpression())) {
            return AjaxResult.error((String)"cron\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e");
        }
        sysJob.setCreateBy(SecurityUtils.getUsername());
        return this.toAjax(this.jobService.insertJob(sysJob));
    }

    @PreAuthorize(value="@ss.hasPermi('monitor:job:edit')")
    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysJob sysJob) throws SchedulerException, TaskException {
        if (!CronUtils.isValid(sysJob.getCronExpression())) {
            return AjaxResult.error((String)"cron\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e");
        }
        sysJob.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.jobService.updateJob(sysJob));
    }

    @PreAuthorize(value="@ss.hasPermi('monitor:job:changeStatus')")
    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/changeStatus"})
    public AjaxResult changeStatus(@RequestBody SysJob job) throws SchedulerException {
        SysJob newJob = this.jobService.selectJobById(job.getJobId());
        newJob.setStatus(job.getStatus());
        return this.toAjax(this.jobService.changeStatus(newJob));
    }

    @PreAuthorize(value="@ss.hasPermi('monitor:job:changeStatus')")
    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/run"})
    public AjaxResult run(@RequestBody SysJob job) throws SchedulerException {
        this.jobService.run(job);
        return AjaxResult.success();
    }

    @PreAuthorize(value="@ss.hasPermi('monitor:job:remove')")
    @Log(title="\u5b9a\u65f6\u4efb\u52a1", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{jobIds}"})
    public AjaxResult remove(@PathVariable Long[] jobIds) throws SchedulerException, TaskException {
        this.jobService.deleteJobByIds(jobIds);
        return AjaxResult.success();
    }
}

