/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.archives.controller;

import com.ruoyi.archives.domain.ArchiveFileInfo;
import com.ruoyi.archives.domain.ArchiveRecordInfo;
import com.ruoyi.archives.domain.FileSearchVo;
import com.ruoyi.archives.domain.export.ArchivesModel;
import com.ruoyi.archives.domain.export.inVolume.JJInVolumeExport;
import com.ruoyi.archives.domain.export.inVolume.WSInVolumeExport;
import com.ruoyi.archives.domain.export.inVolume.ZXInVolumeExport;
import com.ruoyi.archives.domain.export.inVolume.ZXXMInVolumeExport;
import com.ruoyi.archives.service.IArchiveFileInfoService;
import com.ruoyi.archives.service.IArchiveRecordInfoService;
import com.ruoyi.archives.util.ExportUitl;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/archives/fileinfo"})
public class ArchiveFileInfoController
extends BaseController {
    @Autowired
    private IArchiveFileInfoService archiveFileInfoService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private IArchiveRecordInfoService archiveRecordInfoService;

    @PreAuthorize(value="@ss.hasPermi('fileinfo:info:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(ArchiveFileInfo archiveFileInfo) {
        this.startPage();
        List<ArchiveFileInfo> list = this.archiveFileInfoService.selectArchiveFileInfoList(archiveFileInfo);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('fileinfo:info:export')")
    @Log(title="\u6587\u4ef6\u4fe1\u606f", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/export"})
    public AjaxResult export(ArchiveFileInfo archiveFileInfo) {
        List<ArchiveFileInfo> list = this.archiveFileInfoService.selectArchiveFileInfoList(archiveFileInfo);
        ExcelUtil util = new ExcelUtil(ArchiveFileInfo.class);
        return util.exportExcel(list, "info");
    }

    @PreAuthorize(value="@ss.hasPermi('fileinfo:info:exportModel')")
    @Log(title="\u6587\u4ef6\u4fe1\u606f", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/exportModel"})
    public AjaxResult exportModel(ArchiveRecordInfo archiveRecordInfo) {
        if (archiveRecordInfo.getSearchDate() != null && !"".equals(archiveRecordInfo.getSearchDate())) {
            String[] date = archiveRecordInfo.getSearchDate().split(",");
            archiveRecordInfo.setSearchBeginDate(date[0]);
            archiveRecordInfo.setSearchEndDate(date[1]);
        }
        List<ArchiveFileInfo> list = this.archiveRecordInfoService.ExportFile(archiveRecordInfo);
        String code = archiveRecordInfo.getArchiveCategory();
        ArchivesModel inVolumeModel = null;
        ExcelUtil inVolumeUtil = null;
        ArrayList inVolumeList = null;
        String boxName = null;
        if (code.equals("WS")) {
            inVolumeModel = new WSInVolumeExport();
            inVolumeList = new ArrayList();
            inVolumeUtil = new ExcelUtil(WSInVolumeExport.class);
            boxName = "\u6587\u4e66";
        } else if (code.equals("JJ")) {
            inVolumeModel = new JJInVolumeExport();
            inVolumeList = new ArrayList();
            inVolumeUtil = new ExcelUtil(JJInVolumeExport.class);
            boxName = "\u57fa\u5efa";
        } else if (code.equals("ZXXM")) {
            inVolumeModel = new ZXXMInVolumeExport();
            inVolumeList = new ArrayList();
            inVolumeUtil = new ExcelUtil(JJInVolumeExport.class);
            boxName = "\u54a8\u8be2\u9879\u76ee";
        } else if (code.equals("ZX")) {
            inVolumeModel = new ZXInVolumeExport();
            inVolumeList = new ArrayList();
            inVolumeUtil = new ExcelUtil(JJInVolumeExport.class);
            boxName = "\u589e\u9009";
        }
        List inVolumeModels = ExportUitl.getInVolumeModels(inVolumeModel, list, inVolumeList);
        String sheetName = boxName + "\u5377\u5185\u6587\u4ef6";
        AjaxResult ajaxResult = inVolumeUtil.exportExcel(inVolumeModels, sheetName);
        return ajaxResult;
    }

    @PreAuthorize(value="@ss.hasPermi('fileinfo:info:query')")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") String id) {
        return AjaxResult.success((Object)((Object)this.archiveFileInfoService.selectArchiveFileInfoById(id)));
    }

    @PreAuthorize(value="@ss.hasPermi('fileinfo:info:add')")
    @Log(title="\u6587\u4ef6\u4fe1\u606f", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ArchiveFileInfo archiveFileInfo) {
        Integer num = 1;
        Long size = this.redisTemplate.opsForList().size((Object)archiveFileInfo.getArId());
        if (size > 0L) {
            List leve = this.redisTemplate.opsForList().range((Object)archiveFileInfo.getArId(), 0L, -1L);
            num = (Integer)leve.get(leve.size() - 1);
            num = num + 1;
        }
        this.redisTemplate.opsForList().rightPush((Object)archiveFileInfo.getArId(), (Object)num);
        archiveFileInfo.setArSort(String.format("%0" + archiveFileInfo.getNumLength() + "d", num));
        archiveFileInfo.setUpdateTime(new Date());
        archiveFileInfo.setCreateId(SecurityUtils.getUserId().toString());
        archiveFileInfo.setCreateUser(SecurityUtils.getNickName());
        return this.toAjax(this.archiveFileInfoService.insertArchiveFileInfo(archiveFileInfo));
    }

    @PreAuthorize(value="@ss.hasPermi('fileinfo:info:edit')")
    @Log(title="\u6587\u4ef6\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ArchiveFileInfo archiveFileInfo) {
        return this.toAjax(this.archiveFileInfoService.updateArchiveFileInfo(archiveFileInfo));
    }

    @PreAuthorize(value="@ss.hasPermi('fileinfo:info:remove')")
    @Log(title="\u6587\u4ef6\u4fe1\u606f", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable String[] ids) {
        return this.toAjax(this.archiveFileInfoService.deleteArchiveFileInfoByIds(ids));
    }

    @PreAuthorize(value="@ss.hasPermi('fileSearchInfo:info:list')")
    @GetMapping(value={"/fileSearchList"})
    public TableDataInfo fileSearchList(FileSearchVo fileSearchVo) {
        this.startPage();
        List<FileSearchVo> list = this.archiveFileInfoService.fileSearchList(fileSearchVo);
        return this.getDataTable(list);
    }
}

