/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.support;

import io.lettuce.core.LettuceStrings;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.RedisClusterURIUtil;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.support.LettuceFactoryBeanSupport;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RedisClusterClientFactoryBean
extends LettuceFactoryBeanSupport<RedisClusterClient> {
    private boolean verifyPeer = false;
    private Collection<RedisURI> redisURIs;

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.redisURIs == null) {
            if (this.getUri() != null) {
                URI uri = this.getUri();
                LettuceAssert.isTrue(!uri.getScheme().equals("redis-sentinel"), "Sentinel mode not supported when using RedisClusterClient");
                List<RedisURI> redisURIs = RedisClusterURIUtil.toRedisURIs(uri);
                for (RedisURI redisURI : redisURIs) {
                    this.applyProperties(uri.getScheme(), redisURI);
                }
                this.redisURIs = redisURIs;
            } else {
                URI uri = this.getRedisURI().toURI();
                RedisURI redisURI = RedisURI.create(uri);
                this.applyProperties(uri.getScheme(), redisURI);
                this.redisURIs = Collections.singleton(redisURI);
            }
        }
        super.afterPropertiesSet();
    }

    private void applyProperties(String scheme, RedisURI redisURI) {
        if (LettuceStrings.isNotEmpty(this.getPassword())) {
            redisURI.setPassword(this.getPassword());
        }
        if ("rediss".equals(scheme) || "redis+ssl".equals(scheme) || "redis+tls".equals(scheme)) {
            redisURI.setVerifyPeer(this.verifyPeer);
        }
    }

    protected Collection<RedisURI> getRedisURIs() {
        return this.redisURIs;
    }

    protected void destroyInstance(RedisClusterClient instance) throws Exception {
        instance.shutdown();
    }

    public Class<?> getObjectType() {
        return RedisClusterClient.class;
    }

    protected RedisClusterClient createInstance() throws Exception {
        if (this.getClientResources() != null) {
            return RedisClusterClient.create(this.getClientResources(), this.redisURIs);
        }
        return RedisClusterClient.create(this.redisURIs);
    }

    public boolean isVerifyPeer() {
        return this.verifyPeer;
    }

    public void setVerifyPeer(boolean verifyPeer) {
        this.verifyPeer = verifyPeer;
    }
}

