/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.executor;

import com.alibaba.excel.context.WriteContext;
import com.alibaba.excel.enums.HeadKindEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.util.ClassUtils;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.WorkBookUtil;
import com.alibaba.excel.util.WriteHandlerUtils;
import com.alibaba.excel.write.executor.AbstractExcelWriteExecutor;
import com.alibaba.excel.write.metadata.holder.WriteHolder;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.cglib.beans.BeanMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class ExcelWriteAddExecutor
extends AbstractExcelWriteExecutor {
    public ExcelWriteAddExecutor(WriteContext writeContext) {
        super(writeContext);
    }

    public void add(List data) {
        if (CollectionUtils.isEmpty(data)) {
            data = new ArrayList();
        }
        WriteSheetHolder writeSheetHolder = this.writeContext.writeSheetHolder();
        int newRowIndex = writeSheetHolder.getNewRowIndexAndStartDoWrite();
        if (writeSheetHolder.isNew() && !writeSheetHolder.getExcelWriteHeadProperty().hasHead()) {
            newRowIndex += this.writeContext.currentWriteHolder().relativeHeadRowIndex();
        }
        TreeMap<Integer, Field> sortedAllFiledMap = new TreeMap<Integer, Field>();
        int relativeRowIndex = 0;
        for (Object oneRowData : data) {
            int n = relativeRowIndex + newRowIndex;
            this.addOneRowOfDataToExcel(oneRowData, n, relativeRowIndex, sortedAllFiledMap);
            ++relativeRowIndex;
        }
    }

    private void addOneRowOfDataToExcel(Object oneRowData, int n, int relativeRowIndex, Map<Integer, Field> sortedAllFiledMap) {
        if (oneRowData == null) {
            return;
        }
        WriteHandlerUtils.beforeRowCreate(this.writeContext, n, relativeRowIndex, Boolean.FALSE);
        Row row = WorkBookUtil.createRow(this.writeContext.writeSheetHolder().getSheet(), n);
        WriteHandlerUtils.afterRowCreate(this.writeContext, row, relativeRowIndex, Boolean.FALSE);
        if (oneRowData instanceof List) {
            this.addBasicTypeToExcel((List)oneRowData, row, relativeRowIndex);
        } else {
            this.addJavaObjectToExcel(oneRowData, row, relativeRowIndex, sortedAllFiledMap);
        }
        WriteHandlerUtils.afterRowDispose(this.writeContext, row, relativeRowIndex, Boolean.FALSE);
    }

    private void addBasicTypeToExcel(List<Object> oneRowData, Row row, int relativeRowIndex) {
        if (CollectionUtils.isEmpty(oneRowData)) {
            return;
        }
        Map<Integer, Head> headMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getHeadMap();
        int dataIndex = 0;
        int cellIndex = 0;
        for (Map.Entry<Integer, Head> entry : headMap.entrySet()) {
            if (dataIndex >= oneRowData.size()) {
                return;
            }
            cellIndex = entry.getKey();
            Head head = entry.getValue();
            this.doAddBasicTypeToExcel(oneRowData, head, row, relativeRowIndex, dataIndex++, cellIndex);
        }
        if (dataIndex >= oneRowData.size()) {
            return;
        }
        if (cellIndex != 0) {
            ++cellIndex;
        }
        int size = oneRowData.size() - dataIndex;
        for (int i = 0; i < size; ++i) {
            this.doAddBasicTypeToExcel(oneRowData, null, row, relativeRowIndex, dataIndex++, cellIndex++);
        }
    }

    private void doAddBasicTypeToExcel(List<Object> oneRowData, Head head, Row row, int relativeRowIndex, int dataIndex, int cellIndex) {
        WriteHandlerUtils.beforeCellCreate(this.writeContext, row, head, cellIndex, relativeRowIndex, Boolean.FALSE);
        Cell cell = WorkBookUtil.createCell(row, cellIndex);
        WriteHandlerUtils.afterCellCreate(this.writeContext, cell, head, relativeRowIndex, Boolean.FALSE);
        Object value = oneRowData.get(dataIndex);
        CellData cellData = this.converterAndSet(this.writeContext.currentWriteHolder(), value == null ? null : value.getClass(), cell, value, null, head, relativeRowIndex);
        WriteHandlerUtils.afterCellDispose(this.writeContext, cellData, cell, head, (Integer)relativeRowIndex, Boolean.FALSE);
    }

    private void addJavaObjectToExcel(Object oneRowData, Row row, int relativeRowIndex, Map<Integer, Field> sortedAllFiledMap) {
        Cell cell;
        WriteHolder currentWriteHolder = this.writeContext.currentWriteHolder();
        BeanMap beanMap = BeanMap.create((Object)oneRowData);
        HashSet<String> beanMapHandledSet = new HashSet<String>();
        int cellIndex = 0;
        if (HeadKindEnum.CLASS.equals((Object)this.writeContext.currentWriteHolder().excelWriteHeadProperty().getHeadKind())) {
            Map<Integer, Head> headMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getHeadMap();
            Map<Integer, ExcelContentProperty> contentPropertyMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getContentPropertyMap();
            for (Map.Entry<Integer, ExcelContentProperty> entry : contentPropertyMap.entrySet()) {
                cellIndex = entry.getKey();
                ExcelContentProperty excelContentProperty = entry.getValue();
                String name = excelContentProperty.getField().getName();
                if (!beanMap.containsKey((Object)name)) continue;
                Head head = headMap.get(cellIndex);
                WriteHandlerUtils.beforeCellCreate(this.writeContext, row, head, cellIndex, relativeRowIndex, Boolean.FALSE);
                cell = WorkBookUtil.createCell(row, cellIndex);
                WriteHandlerUtils.afterCellCreate(this.writeContext, cell, head, relativeRowIndex, Boolean.FALSE);
                Object value = beanMap.get((Object)name);
                CellData cellData = this.converterAndSet(currentWriteHolder, excelContentProperty.getField().getType(), cell, value, excelContentProperty, head, relativeRowIndex);
                WriteHandlerUtils.afterCellDispose(this.writeContext, cellData, cell, head, (Integer)relativeRowIndex, Boolean.FALSE);
                beanMapHandledSet.add(name);
            }
        }
        if (beanMapHandledSet.size() == beanMap.size()) {
            return;
        }
        Map<String, Field> ignoreMap = this.writeContext.currentWriteHolder().excelWriteHeadProperty().getIgnoreMap();
        this.initSortedAllFiledMapFieldList(oneRowData.getClass(), sortedAllFiledMap);
        for (Map.Entry<Integer, Field> entry : sortedAllFiledMap.entrySet()) {
            boolean uselessData;
            cellIndex = entry.getKey();
            Field field = entry.getValue();
            String filedName = field.getName();
            boolean bl = uselessData = !beanMap.containsKey((Object)filedName) || beanMapHandledSet.contains(filedName) || ignoreMap.containsKey(filedName);
            if (uselessData) continue;
            Object value = beanMap.get((Object)filedName);
            WriteHandlerUtils.beforeCellCreate(this.writeContext, row, null, cellIndex, relativeRowIndex, Boolean.FALSE);
            cell = WorkBookUtil.createCell(row, cellIndex);
            WriteHandlerUtils.afterCellCreate(this.writeContext, cell, null, relativeRowIndex, Boolean.FALSE);
            CellData cellData = this.converterAndSet(currentWriteHolder, value == null ? null : value.getClass(), cell, value, null, null, relativeRowIndex);
            WriteHandlerUtils.afterCellDispose(this.writeContext, cellData, cell, null, (Integer)relativeRowIndex, Boolean.FALSE);
        }
    }

    private void initSortedAllFiledMapFieldList(Class clazz, Map<Integer, Field> sortedAllFiledMap) {
        if (!sortedAllFiledMap.isEmpty()) {
            return;
        }
        WriteWorkbookHolder writeWorkbookHolder = this.writeContext.writeWorkbookHolder();
        boolean needIgnore = !CollectionUtils.isEmpty(writeWorkbookHolder.getExcludeColumnFiledNames()) || !CollectionUtils.isEmpty(writeWorkbookHolder.getExcludeColumnIndexes()) || !CollectionUtils.isEmpty(writeWorkbookHolder.getIncludeColumnFiledNames()) || !CollectionUtils.isEmpty(writeWorkbookHolder.getIncludeColumnIndexes());
        ClassUtils.declaredFields(clazz, sortedAllFiledMap, writeWorkbookHolder.getWriteWorkbook().getConvertAllFiled(), needIgnore, writeWorkbookHolder);
    }
}

