/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.derived.latency;

import org.terracotta.statistics.derived.latency.LatencyAccumulator;
import org.terracotta.statistics.derived.latency.LatencyStatistic;
import org.terracotta.statistics.observer.ChainedEventObserver;

public class LatencyPeriodAccumulator
implements LatencyStatistic,
ChainedEventObserver {
    private final LatencyAccumulator accumulator;
    private final long start;
    private final long end;

    LatencyPeriodAccumulator(long start, long length, long ... latencies) {
        this.start = start;
        this.end = start + length;
        this.accumulator = LatencyAccumulator.accumulator(latencies);
    }

    public boolean isBefore(long time) {
        return this.end <= time;
    }

    public boolean isAfter(long time) {
        return this.start > time;
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public LatencyAccumulator accumulator() {
        return this.accumulator;
    }

    public boolean tryAccumulate(long time, long latency) {
        if (time < this.end) {
            this.accumulator.accumulate(latency);
            return true;
        }
        return false;
    }

    @Override
    public void event(long timeNs, long latencyNs) {
        this.tryAccumulate(timeNs, latencyNs);
    }

    @Override
    public Long minimum() {
        return this.accumulator.minimum();
    }

    @Override
    public Long maximum() {
        return this.accumulator.maximum();
    }

    @Override
    public double average() {
        return this.accumulator.average();
    }

    public String toString() {
        return "LatencyPeriodAccumulator{start=" + this.start + ", end=" + this.end + ", accumulator=" + this.accumulator + '}';
    }
}

