/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.archives.service.impl;

import com.ruoyi.archives.domain.ArchivesNonDigitalDoc;
import com.ruoyi.archives.mapper.ArchivesNonDigitalDocMapper;
import com.ruoyi.archives.service.IArchivesNonDigitalDocService;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.utils.uuid.IdUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ArchivesNonDigitalDocServiceImpl
implements IArchivesNonDigitalDocService {
    @Autowired
    private ArchivesNonDigitalDocMapper archivesNonDigitalDocMapper;

    @Override
    public ArchivesNonDigitalDoc selectArchivesNonDigitalDocById(String id) {
        return this.archivesNonDigitalDocMapper.selectArchivesNonDigitalDocById(id);
    }

    @Override
    public List<ArchivesNonDigitalDoc> selectArchivesNonDigitalDocList(ArchivesNonDigitalDoc archivesNonDigitalDoc) {
        return this.archivesNonDigitalDocMapper.selectArchivesNonDigitalDocList(archivesNonDigitalDoc);
    }

    @Override
    public int insertArchivesNonDigitalDoc(ArchivesNonDigitalDoc archivesNonDigitalDoc) {
        archivesNonDigitalDoc.setId(IdUtils.fastSimpleUUID());
        archivesNonDigitalDoc.setCreateTime(DateUtils.getNowDate());
        return this.archivesNonDigitalDocMapper.insertArchivesNonDigitalDoc(archivesNonDigitalDoc);
    }

    @Override
    public int updateArchivesNonDigitalDoc(ArchivesNonDigitalDoc archivesNonDigitalDoc) {
        archivesNonDigitalDoc.setUpdateTime(DateUtils.getNowDate());
        return this.archivesNonDigitalDocMapper.updateArchivesNonDigitalDoc(archivesNonDigitalDoc);
    }

    @Override
    public int deleteArchivesNonDigitalDocByIds(String[] ids) {
        return this.archivesNonDigitalDocMapper.deleteArchivesNonDigitalDocByIds(ids);
    }

    @Override
    public int deleteArchivesNonDigitalDocById(String id) {
        return this.archivesNonDigitalDocMapper.deleteArchivesNonDigitalDocById(id);
    }

    @Override
    public String updateExcelData(MultipartFile file) {
        ExcelUtil util = new ExcelUtil(ArchivesNonDigitalDoc.class);
        try {
            List docList = util.importExcel(file.getInputStream());
            if (docList.isEmpty()) {
                return "\u6ca1\u6709\u9700\u5bfc\u5165\u7684\u6570\u636e\uff01";
            }
            for (ArchivesNonDigitalDoc doc : docList) {
                ArchivesNonDigitalDoc param = new ArchivesNonDigitalDoc();
                param.setDocName(doc.getDocName());
                List<ArchivesNonDigitalDoc> tempList = this.archivesNonDigitalDocMapper.selectArchivesNonDigitalDocList(param);
                if (tempList.size() == 0) {
                    this.insertArchivesNonDigitalDoc(doc);
                    continue;
                }
                ArchivesNonDigitalDoc insert = tempList.get(0);
                doc.setId(insert.getId());
                this.updateArchivesNonDigitalDoc(doc);
            }
            return "\u6210\u529f\u5bfc\u5165" + docList.size() + "\u6761\u6570\u636e\uff01";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String importExcelData(MultipartFile file) {
        ExcelUtil util = new ExcelUtil(ArchivesNonDigitalDoc.class);
        try {
            List docList = util.importExcel(file.getInputStream());
            if (docList.isEmpty()) {
                return "\u6ca1\u6709\u9700\u5bfc\u5165\u7684\u6570\u636e\uff01";
            }
            for (ArchivesNonDigitalDoc doc : docList) {
                this.insertArchivesNonDigitalDoc(doc);
            }
            return "\u6210\u529f\u5bfc\u5165" + docList.size() + "\u6761\u6570\u636e\uff01";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

