/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.core.internal.util.ClassLoading;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.ConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.model.CacheTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlConfiguration
implements Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlConfiguration.class);
    private final URL xml;
    private final ConfigurationParser parser;
    private final Configuration configuration;
    private final Map<String, CacheTemplate> templates;
    private final String xmlString;

    public XmlConfiguration(URL url) throws XmlConfigurationException {
        this(url, ClassLoading.getDefaultClassLoader());
    }

    public XmlConfiguration(URL url, ClassLoader classLoader) throws XmlConfigurationException {
        this(url, classLoader, Collections.emptyMap());
    }

    public XmlConfiguration(URL url, ClassLoader classLoader, Map<String, ClassLoader> cacheClassLoaders) throws XmlConfigurationException {
        if (url == null) {
            throw new NullPointerException("The url can not be null");
        }
        if (classLoader == null) {
            throw new NullPointerException("The classLoader can not be null");
        }
        if (cacheClassLoaders == null) {
            throw new NullPointerException("The cacheClassLoaders map can not be null");
        }
        this.xml = url;
        try {
            this.parser = new ConfigurationParser();
            ConfigurationParser.XmlConfigurationWrapper xmlConfigurationWrapper = this.parser.parseConfiguration(url.toExternalForm(), classLoader, cacheClassLoaders);
            this.configuration = xmlConfigurationWrapper.getConfiguration();
            this.templates = xmlConfigurationWrapper.getTemplates();
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(this.xml.openStream(), Charset.defaultCharset()));){
                this.xmlString = buffer.lines().collect(Collectors.joining("\n"));
            }
        }
        catch (XmlConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlConfigurationException("Error parsing XML configuration at " + url, e);
        }
    }

    public XmlConfiguration(Configuration configuration) {
        this.xml = null;
        this.configuration = configuration;
        this.templates = Collections.emptyMap();
        try {
            this.parser = new ConfigurationParser();
            this.xmlString = this.parser.unparseConfiguration(configuration);
        }
        catch (XmlConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlConfigurationException("Error unparsing configuration: " + configuration, e);
        }
    }

    public String toString() {
        return this.xmlString;
    }

    public URL getURL() {
        return this.xml;
    }

    public <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilderFromTemplate(String name, Class<K> keyType, Class<V> valueType) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.internalCacheConfigurationBuilderFromTemplate(name, keyType, valueType, null);
    }

    public <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilderFromTemplate(String name, Class<K> keyType, Class<V> valueType, ResourcePools resourcePools) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.internalCacheConfigurationBuilderFromTemplate(name, keyType, valueType, resourcePools);
    }

    public <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilderFromTemplate(String name, Class<K> keyType, Class<V> valueType, Builder<? extends ResourcePools> resourcePoolsBuilder) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.internalCacheConfigurationBuilderFromTemplate(name, keyType, valueType, resourcePoolsBuilder.build());
    }

    private <K, V> CacheConfigurationBuilder<K, V> internalCacheConfigurationBuilderFromTemplate(String name, Class<K> keyType, Class<V> valueType, ResourcePools resourcePools) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        CacheTemplate cacheTemplate = this.templates.get(name);
        if (cacheTemplate == null) {
            return null;
        }
        XmlConfiguration.checkTemplateTypeConsistency("key", keyType, cacheTemplate);
        XmlConfiguration.checkTemplateTypeConsistency("value", valueType, cacheTemplate);
        if ((resourcePools == null || resourcePools.getResourceTypeSet().isEmpty()) && cacheTemplate.getHeap() == null && cacheTemplate.getResources().isEmpty()) {
            throw new IllegalStateException("Template defines no resources, and none were provided");
        }
        if (resourcePools == null) {
            resourcePools = this.parser.getResourceConfigurationParser().parseResourceConfiguration(cacheTemplate, ResourcePoolsBuilder.newResourcePoolsBuilder());
        }
        return this.parser.parseServiceConfigurations(CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, resourcePools), ClassLoading.getDefaultClassLoader(), cacheTemplate);
    }

    private static <T> void checkTemplateTypeConsistency(String type, Class<T> providedType, CacheTemplate template) throws ClassNotFoundException {
        ClassLoader defaultClassLoader = ClassLoading.getDefaultClassLoader();
        Class<Object> templateType = type.equals("key") ? XmlConfiguration.getClassForName(template.keyType(), defaultClassLoader) : XmlConfiguration.getClassForName(template.valueType(), defaultClassLoader);
        if (providedType == null || !templateType.isAssignableFrom(providedType)) {
            throw new IllegalArgumentException("CacheTemplate '" + template.id() + "' declares " + type + " type of " + templateType.getName() + ". Provided: " + providedType);
        }
    }

    public static Class<?> getClassForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(name, true, classLoader);
    }

    @Override
    public Map<String, CacheConfiguration<?, ?>> getCacheConfigurations() {
        return this.configuration.getCacheConfigurations();
    }

    @Override
    public Collection<ServiceCreationConfiguration<?>> getServiceCreationConfigurations() {
        return this.configuration.getServiceCreationConfigurations();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.configuration.getClassLoader();
    }
}

