/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core.v3;

import com.kingbase8.core.ResultCursor;
import com.kingbase8.core.Utils;
import com.kingbase8.core.v3.SimpleQuery;
import java.lang.ref.PhantomReference;

public class Portal
implements ResultCursor {
    private final SimpleQuery query;
    private final String portalName;
    private final byte[] encodedName;
    private PhantomReference<?> cleanupRef;

    Portal(SimpleQuery query, String portalName) {
        this.query = query;
        this.portalName = portalName;
        this.encodedName = Utils.encodeUTF8(portalName);
    }

    @Override
    public void close() {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
            this.cleanupRef = null;
        }
    }

    public String getPortalName() {
        return this.portalName;
    }

    byte[] getEncodedPortalName() {
        return this.encodedName;
    }

    SimpleQuery getQuery() {
        return this.query;
    }

    void setCleanupRef(PhantomReference<?> cleanupRef) {
        this.cleanupRef = cleanupRef;
    }

    public String toString() {
        return this.portalName;
    }
}

