/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.dynamic.parameter.MethodParametersAccessor;
import io.lettuce.core.dynamic.support.ClassTypeInformation;
import io.lettuce.core.dynamic.support.TypeInformation;
import io.lettuce.core.internal.LettuceAssert;
import java.util.Iterator;

class CodecAwareMethodParametersAccessor
implements MethodParametersAccessor {
    private final MethodParametersAccessor delegate;
    private final TypeContext typeContext;

    public CodecAwareMethodParametersAccessor(MethodParametersAccessor delegate, RedisCodec<?, ?> redisCodec) {
        LettuceAssert.notNull(delegate, "MethodParametersAccessor must not be null");
        LettuceAssert.notNull(redisCodec, "RedisCodec must not be null");
        this.delegate = delegate;
        this.typeContext = new TypeContext(redisCodec);
    }

    public CodecAwareMethodParametersAccessor(MethodParametersAccessor delegate, TypeContext typeContext) {
        LettuceAssert.notNull(delegate, "MethodParametersAccessor must not be null");
        LettuceAssert.notNull(typeContext, "TypeContext must not be null");
        this.delegate = delegate;
        this.typeContext = typeContext;
    }

    @Override
    public int getParameterCount() {
        return this.delegate.getParameterCount();
    }

    @Override
    public Object getBindableValue(int index) {
        return this.delegate.getBindableValue(index);
    }

    @Override
    public boolean isKey(int index) {
        if (this.delegate.isValue(index)) {
            return false;
        }
        if (this.delegate.isKey(index)) {
            return true;
        }
        Object bindableValue = this.getBindableValue(index);
        return bindableValue != null && this.typeContext.keyType.getType().isAssignableFrom(bindableValue.getClass());
    }

    @Override
    public boolean isValue(int index) {
        if (this.delegate.isKey(index)) {
            return false;
        }
        if (this.delegate.isValue(index)) {
            return true;
        }
        Object bindableValue = this.getBindableValue(index);
        return bindableValue != null && this.typeContext.valueType.getType().isAssignableFrom(bindableValue.getClass());
    }

    @Override
    public Iterator<Object> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int resolveParameterIndex(String name) {
        return this.delegate.resolveParameterIndex(name);
    }

    @Override
    public boolean isBindableNullValue(int index) {
        return this.delegate.isBindableNullValue(index);
    }

    public static class TypeContext {
        final TypeInformation<?> keyType;
        final TypeInformation<?> valueType;

        public TypeContext(RedisCodec<?, ?> redisCodec) {
            LettuceAssert.notNull(redisCodec, "RedisCodec must not be null");
            ClassTypeInformation<?> typeInformation = ClassTypeInformation.from(redisCodec.getClass());
            this.keyType = typeInformation.getTypeArgument((Class)RedisCodec.class, 0);
            this.valueType = typeInformation.getTypeArgument((Class)RedisCodec.class, 1);
        }
    }
}

