/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.cache.selector;

import com.alibaba.excel.cache.Ehcache;
import com.alibaba.excel.cache.MapCache;
import com.alibaba.excel.cache.ReadCache;
import com.alibaba.excel.cache.selector.ReadCacheSelector;
import java.io.IOException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleReadCacheSelector
implements ReadCacheSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleReadCacheSelector.class);
    private static final long B2M = 1000000L;
    private static final int DEFAULT_MAX_USE_MAP_CACHE_SIZE = 5;
    private static final int DEFAULT_MAX_EHCACHE_ACTIVATE_SIZE = 20;
    private long maxUseMapCacheSize;
    private int maxCacheActivateSize;

    public SimpleReadCacheSelector() {
        this(5L, 20);
    }

    public SimpleReadCacheSelector(long maxUseMapCacheSize, int maxCacheActivateSize) {
        this.maxUseMapCacheSize = maxUseMapCacheSize <= 0L ? 5L : maxUseMapCacheSize;
        this.maxCacheActivateSize = maxCacheActivateSize <= 0 ? 20 : maxCacheActivateSize;
    }

    @Override
    public ReadCache readCache(PackagePart sharedStringsTablePackagePart) {
        long size = sharedStringsTablePackagePart.getSize();
        if (size < 0L) {
            try {
                size = sharedStringsTablePackagePart.getInputStream().available();
            }
            catch (IOException e) {
                LOGGER.warn("Unable to get file size, default used MapCache");
                return new MapCache();
            }
        }
        if (size < this.maxUseMapCacheSize * 1000000L) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Use map cache.size:{}", (Object)size);
            }
            return new MapCache();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Use ehcache.size:{}", (Object)size);
        }
        return new Ehcache(this.maxCacheActivateSize);
    }
}

