/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.utils;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.ruoyi.common.utils.ExcelStringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelListener
extends AnalysisEventListener {
    private static final Logger log = LoggerFactory.getLogger(ExcelListener.class);
    private List<Object> dataList = new ArrayList<Object>();
    private static final String SERIAL_VERSION_UID = "serialVersionUID";

    public void invoke(Object object, AnalysisContext context) {
        for (Field f : object.getClass().getDeclaredFields()) {
            String itemStr;
            Object item;
            String regexp;
            f.setAccessible(true);
            if (f.getName().equals("year")) {
                regexp = "[0-9]{4}";
                item = (String)f.get(object);
                if (item == null || ((String)item).matches(regexp)) continue;
                throw new Exception("sheet:[" + context.readSheetHolder().getSheetName() + "];[\u884c\u53f7:" + (context.readRowHolder().getRowIndex() + 1) + "]\u5e74\u4efd\u683c\u5f0f\u9519\u8bef");
            }
            if (f.getName().equals("storageTime")) {
                regexp = "^[A-Za-z0-9]+";
                item = (String)f.get(object);
                if (item == null || ((String)item).matches(regexp)) continue;
                throw new Exception("sheet:[" + context.readSheetHolder().getSheetName() + "];[\u884c\u53f7:" + (context.readRowHolder().getRowIndex() + 1) + "]\u4fdd\u7ba1\u671f\u9650\u683c\u5f0f\u9519\u8bef,\u8bf7\u67e5\u770b\u5bfc\u5165\u8bf4\u660e,\u586b\u5199\u5bf9\u5e94\u952e\u503c");
            }
            if (f.getName().equals("department")) {
                regexp = "[0-9]+";
                item = (Long)f.get(object);
                itemStr = String.valueOf(item);
                if (item == null || itemStr.matches(regexp)) continue;
                throw new Exception("sheet:[" + context.readSheetHolder().getSheetName() + "];[\u884c\u53f7:" + (context.readRowHolder().getRowIndex() + 1) + "]\u7acb\u5377\u90e8\u95e8\u683c\u5f0f\u9519\u8bef,\u8bf7\u67e5\u770b\u5bfc\u5165\u8bf4\u660e,\u586b\u5199\u90e8\u95e8Id");
            }
            if (f.getName().equals("secretLevel")) {
                regexp = "[0-9]+";
                item = (String)f.get(object);
                if (item == null || ((String)item).matches(regexp)) continue;
                throw new Exception("sheet:[" + context.readSheetHolder().getSheetName() + "];[\u884c\u53f7:" + (context.readRowHolder().getRowIndex() + 1) + "]\u5bc6\u7ea7\u683c\u5f0f\u9519\u8bef,\u8bf7\u67e5\u770b\u5bfc\u5165\u8bf4\u660e,\u586b\u5199\u5bf9\u5e94\u952e\u503c");
            }
            if (f.getName().equals("archiveScope")) {
                regexp = "[0-9]+";
                item = (Long)f.get(object);
                itemStr = String.valueOf(item);
                if (item == null || itemStr.matches(regexp)) continue;
                throw new Exception("sheet:[" + context.readSheetHolder().getSheetName() + "];[\u884c\u53f7:" + (context.readRowHolder().getRowIndex() + 1) + "]\u5f52\u6863\u8303\u56f4\u683c\u5f0f\u9519\u8bef,\u8bf7\u67e5\u770b\u5bfc\u5165\u8bf4\u660e,\u586b\u5199\u5bf9\u5e94\u7c7b\u76eeId");
            }
            if (!f.getName().equals("arSort")) continue;
            regexp = "[0-9]+";
            String itemStr2 = (String)f.get(object);
            if (itemStr2 == null || itemStr2.matches(regexp)) continue;
            throw new Exception("sheet:[" + context.readSheetHolder().getSheetName() + "];[\u884c\u53f7:" + (context.readRowHolder().getRowIndex() + 1) + "]\u5377\u5185\u987a\u5e8f\u53f7\u683c\u5f0f\u9519\u8bef,\u8bf7\u586b\u5199\u6570\u5b57,\u6ce8\u610f\u4f4d\u6570,\u4f4d\u6570\u4e0d\u591f\u8bf7\u88650");
        }
        if (!ExcelListener.checkObjAllFieldsIsNull(object)) {
            this.dataList.add(object);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
    }

    private static boolean checkObjAllFieldsIsNull(Object object) {
        if (null == object) {
            return true;
        }
        try {
            for (Field f : object.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                ExcelProperty property = f.getAnnotation(ExcelProperty.class);
                if (property == null || SERIAL_VERSION_UID.equals(f.getName()) || f.get(object) == null || !ExcelStringUtils.isNotBlank(f.get(object).toString())) continue;
                return false;
            }
        }
        catch (Exception e) {
            log.error("\u5224\u65ad\u5bf9\u8c61\u4e2d\u5c5e\u6027\u503c\u662f\u5426\u5168\u4e3a\u7a7a\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        return true;
    }

    public List<Object> getDataList() {
        return this.dataList;
    }
}

