/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.archives.service.impl;

import com.ruoyi.archives.domain.ArchiveCategoryInfo;
import com.ruoyi.archives.domain.ArchiveFileInfo;
import com.ruoyi.archives.domain.ArchiveRecordInfo;
import com.ruoyi.archives.domain.ArchivesHkHistory;
import com.ruoyi.archives.domain.FileSearchVo;
import com.ruoyi.archives.domain.FileUploadList;
import com.ruoyi.archives.domain.importdata.CapitalArchivesModel;
import com.ruoyi.archives.domain.importdata.ContractArchivesModel;
import com.ruoyi.archives.domain.importdata.JYWJArchivesModel;
import com.ruoyi.archives.domain.importdata.KeyValue;
import com.ruoyi.archives.domain.importdata.MediaArchivesModel;
import com.ruoyi.archives.domain.importdata.ProjectArchivesModel;
import com.ruoyi.archives.domain.importdata.WTArchivesMdel;
import com.ruoyi.archives.domain.importdata.WritArchivesModel;
import com.ruoyi.archives.domain.importdata.YJJLArchivesModel;
import com.ruoyi.archives.domain.importdata.YearbooksArchivesModel;
import com.ruoyi.archives.domain.importdata.ZXArchivesModel;
import com.ruoyi.archives.domain.importdata.file.CapitalFileModel;
import com.ruoyi.archives.domain.importdata.file.CommonFileModel;
import com.ruoyi.archives.domain.importdata.file.ContractFileModel;
import com.ruoyi.archives.domain.importdata.file.MediaFileModel;
import com.ruoyi.archives.domain.importdata.file.WSFileModel;
import com.ruoyi.archives.service.ArchiveImportService;
import com.ruoyi.archives.service.IArchiveCategoryInfoService;
import com.ruoyi.archives.service.IArchiveFileInfoService;
import com.ruoyi.archives.service.IArchiveRecordInfoService;
import com.ruoyi.archives.service.IArchivesHkHistoryService;
import com.ruoyi.archives.service.IFileUploadListService;
import com.ruoyi.archives.util.FileUtils;
import com.ruoyi.archives.util.NumberGenUtil;
import com.ruoyi.archives.util.UnPackeUtil;
import com.ruoyi.common.config.ArchiveUploadConfig;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.service.ISysDeptService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(rollbackFor={Exception.class})
public class ArchiveImportServiceImpl
implements ArchiveImportService {
    @Autowired
    private IArchiveRecordInfoService archiveRecordInfoService;
    @Autowired
    private IArchiveFileInfoService archiveFileInfoService;
    @Autowired
    private IArchiveCategoryInfoService categoryInfoService;
    @Autowired
    private NumberGenUtil numberGenUtil;
    @Autowired
    private ISysDeptService sysDeptService;
    @Autowired
    private IFileUploadListService fileUploadListService;
    @Autowired
    private IArchivesHkHistoryService archivesHkHistoryService;
    private static String WS_FILE_NUM_EXAMPLE = "^WS[0-9]{4}-\\w+-[0-9]+";
    private static String WS_HISTORY_NUM_EXAMPLE = "^W[0-9]+-[0-9]+";
    private static String JYWJ_FILE_NUM_EXAMPLE = "^[0-9]{4}-\\w+-[0-9]+";
    private static String SW_FILE_NUM_EXAMPLE = "^\\w+-[0-9]{4}-\\w+-[0-9]+";
    private static String ZX_FILE_NUM_EXAMPLE = "^ZX[0-9]{4}-\\w+-[0-9]+";
    private static String NJ_FILE_NUM_EXAMPLE = "^NJ[0-9]{4}-[0-9]+";
    private static String ZXXM_FILE_NUM_EXAMPLE = "^ZXXM[0-9]+-[0-9]+-[0-9]+";
    private static String JJ_FILE_NUM_EXAMPLE = "^JJ[0-9]+-[0-9]+-[0-9]+";
    private static String SX_FILE_NUM_EXAMPLE = "^SX[0-9]{4}-\\w+-[0-9]+-[0-9]+";
    private static String HT_FILE_NUM_EXAMPLE = "^HT[0-9]{4}-\\w+-[0-9]+";
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
    private static final String RECORD_TYPE = "record";
    private static final String FILE_TYPE = "file";

    @Override
    public AjaxResult importExcel(MultipartFile file, String type) {
        if (file.isEmpty()) {
            return AjaxResult.error((String)"\u6587\u4ef6\u4e3a\u7a7a");
        }
        if (type == null) {
            return AjaxResult.error((String)"\u6863\u6848\u7c7b\u76ee\u672a\u9009\u62e9");
        }
        try {
            if ("JJ".equals(type)) {
                this.jjArchivesModelExcelImport(file, type);
            } else if ("HT".equals(type)) {
                this.htArchivesModelExcelImport(file, type);
            } else if ("SW".equals(type)) {
                this.swArchivesModelExcelImport(file, type);
            } else if ("SX".equals(type)) {
                this.sxArchivesModelExcelImport(file, type);
            } else if ("ZX".equals(type)) {
                this.zxArchivesModelExcelImport(file, type);
            } else if ("WS".equals(type)) {
                this.wsArchivesModelExcelImport(file, type);
            } else if ("ZXXM".equals(type)) {
                this.zxxmArchivesModelExcelImport(file, type);
            } else if ("JYDA".equals(type)) {
                this.jydaArchivesModelExcelImport(file, type);
            } else if ("DAYJJL".equals(type)) {
                this.dayjArchivesModelExcelImport(file, type);
            } else {
                this.njArchivesModelExcelImport(file, type);
            }
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            if (StringUtils.isNotEmpty((String)e.getMessage())) {
                if (e.getMessage().contains("uk_appendix_address") || e.getMessage().contains("uq_appendix_address")) {
                    return AjaxResult.error((String)("[\u9644\u4ef6\u5730\u5740\u6570\u636e\u91cd\u590d]:" + e.getMessage().substring(0, e.getMessage().indexOf("address") + 8)));
                }
                if (e.getMessage().contains("Unparseable date")) {
                    return AjaxResult.error((String)("[" + e.getMessage() + "]:\u683c\u5f0f\u5316\u5f02\u5e38,\u8bf7\u67e5\u770b\u6a21\u677f\u683c\u5f0f\u8981\u6c42\u3002"));
                }
            }
            return AjaxResult.error((String)(e.getMessage() == null ? "\u7a7a\u6307\u9488\u5f02\u5e38" : e.getMessage()));
        }
        return AjaxResult.success();
    }

    @Override
    public AjaxResult deleteImportInfo(String[] ids) {
        try {
            for (String item : ids) {
                ArchiveRecordInfo archiveRecordInfo = this.archiveRecordInfoService.selectArchiveRecordInfoById(item);
                this.deleteImportInfoByType(archiveRecordInfo.getArchiveCategory(), archiveRecordInfo);
            }
        }
        catch (Exception e) {
            return AjaxResult.error((String)e.getMessage());
        }
        return AjaxResult.success();
    }

    private void deleteImportInfoByType(String type, ArchiveRecordInfo archiveRecordInfo) {
        String key = "JJ".equals(type) ? archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getProjectNumber() + "-" + archiveRecordInfo.getCategoryCode() : ("HT".equals(type) ? archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear() + "-" + archiveRecordInfo.getStorageTime() : ("SW".equals(type) ? archiveRecordInfo.getCategoryCode() : ("SX".equals(type) ? archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear() : ("ZX".equals(type) ? archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear() : ("WS".equals(type) ? archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear() : ("ZXXM".equals(type) ? archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getProjectNumber() : ("JYDA".equals(type) ? archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear() : ("DAYJJL".equals(type) ? archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear() : archiveRecordInfo.getArchiveCategory().toUpperCase()))))))));
        this.archiveRecordInfoService.deleteArchiveRecordInfoById(archiveRecordInfo.getId().toString());
        this.archiveFileInfoService.deleteArchiveFIleInfoBYRecordId(archiveRecordInfo.getId());
        if (archiveRecordInfo.getFileNum() != null && archiveRecordInfo.getFileNum().length() > 0) {
            String value = archiveRecordInfo.getFileNum().substring(archiveRecordInfo.getFileNum().lastIndexOf("-") + 1);
            this.numberGenUtil.removeValueByKey(key, Integer.valueOf(value));
        }
        this.numberGenUtil.removeKey(archiveRecordInfo.getId().toString());
    }

    private void htArchivesModelExcelImport(MultipartFile file, String type) throws Exception {
        List archivesModels = ExcelUtil.readExcel((MultipartFile)file, ContractArchivesModel.class, (int)1, (int)2);
        if (archivesModels == null || archivesModels.size() <= 0) {
            throw new RuntimeException("[" + file.getOriginalFilename() + "]\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
        }
        archivesModels = archivesModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveRecordInfo> list = new ArrayList<ArchiveRecordInfo>(archivesModels.size());
        for (int i = 0; i < archivesModels.size(); ++i) {
            SysDept sysDept;
            ContractArchivesModel item = (ContractArchivesModel)((Object)archivesModels.get(i));
            if (StringUtils.isEmpty((String)item.getFileNum()) || StringUtils.isEmpty((String)item.getBoxName())) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u6863\u53f7,\u6848\u5377\u9898\u540d]\u662f\u5426\u586b\u5199\u5b8c\u6574");
            }
            String fileNum = item.getFileNum().trim();
            boolean flag = fileNum.matches(HT_FILE_NUM_EXAMPLE);
            if (Boolean.FALSE == flag) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6863\u53f7\u4e0d\u7b26\u5408\u6807\u51c6,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            ArchiveRecordInfo archiveRecordInfo = new ArchiveRecordInfo();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)archiveRecordInfo));
            if (archiveRecordInfo.getDepartment() != null && (sysDept = this.sysDeptService.selectDeptById(archiveRecordInfo.getDepartment())) == null) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u5f52\u6863\u90e8\u95e8\u586b\u5199\u9519\u8bef,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            String[] split = fileNum.split("-");
            archiveRecordInfo.setFileNum(fileNum);
            archiveRecordInfo.setArchiveCategory(type);
            archiveRecordInfo.setYear(fileNum.substring(type.length(), fileNum.indexOf("-")));
            archiveRecordInfo.setStorageTime(split[1]);
            archiveRecordInfo.setCaseNum(split[2]);
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear() + "-" + archiveRecordInfo.getStorageTime(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            if (StringUtils.isNotEmpty((String)item.getDescriptionTime())) {
                archiveRecordInfo.setDescriptionTime(simpleDateFormat.parse(item.getDescriptionTime()));
            }
            archiveRecordInfo.setCreateId(SecurityUtils.getUserId().toString());
            archiveRecordInfo.setSource("0");
            archiveRecordInfo.setStatus("0");
            archiveRecordInfo.setUpdateTime(DateUtils.getNowDate());
            archiveRecordInfo.setCreateTime(DateUtils.getNowDate());
            list.add(archiveRecordInfo);
        }
        Map<String, ArchiveRecordInfo> stringArchiveRecordInfoMap = this.batchSaveRecordInfoList(list);
        List writFileModels = ExcelUtil.readExcel((MultipartFile)file, ContractFileModel.class, (int)2, (int)2);
        writFileModels = writFileModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveFileInfo> archiveFileInfos = new ArrayList<ArchiveFileInfo>(writFileModels.size());
        if (writFileModels != null && writFileModels.size() > 0) {
            for (int i = 0; i < writFileModels.size(); ++i) {
                ContractFileModel tmp = (ContractFileModel)((Object)writFileModels.get(i));
                if (StringUtils.isEmpty((String)tmp.getRecordFileNum()) || StringUtils.isEmpty((String)tmp.getArSort()) || StringUtils.isEmpty((String)tmp.getTitle())) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014\u5377\u5185\u76ee\u5f55\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u6848\u5377\u6863\u53f7,\u5377\u5185\u987a\u5e8f\u53f7,\u6587\u4ef6\u6807\u9898]\u662f\u5426\u586b\u5199\u5b8c\u6574");
                }
                ArchiveFileInfo archiveFileInfo = new ArchiveFileInfo();
                ArchiveRecordInfo archiveRecordInfo = stringArchiveRecordInfoMap.get(tmp.getRecordFileNum().trim());
                if (archiveRecordInfo == null || archiveRecordInfo.getId() == null) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014\u5377\u5185\u76ee\u5f55\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u6863\u6848\u4fe1\u606f\u8bf7\u68c0\u67e5");
                }
                BeanUtils.copyProperties((Object)((Object)tmp), (Object)((Object)archiveFileInfo));
                if (StringUtils.isNotEmpty((String)tmp.getFileDate())) {
                    archiveFileInfo.setFileDate(simpleDateFormat.parse(tmp.getFileDate()));
                }
                archiveFileInfo.setArId(String.valueOf(archiveRecordInfo.getId()));
                archiveFileInfo.setCreateId(SecurityUtils.getUserId().toString());
                archiveFileInfo.setCreateTime(DateUtils.getNowDate());
                archiveFileInfo.setUpdateTime(DateUtils.getNowDate());
                archiveFileInfo.setStatus("0");
                archiveFileInfos.add(archiveFileInfo);
            }
            this.batchSaveFileInfoList(archiveFileInfos);
        }
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (ArchiveRecordInfo archiveRecordInfo : list) {
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear() + "-" + archiveRecordInfo.getStorageTime(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                this.numberGenUtil.removeValueByKey(keyValues);
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u6863\u53f7" + archiveRecordInfo.getFileNum() + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            KeyValue keyValue = new KeyValue();
            keyValue.setKey(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear() + "-" + archiveRecordInfo.getStorageTime());
            keyValue.setValue(Integer.valueOf(archiveRecordInfo.getCaseNum()));
            keyValues.add(keyValue);
            this.numberGenUtil.pushXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear() + "-" + archiveRecordInfo.getStorageTime(), Integer.valueOf(archiveRecordInfo.getCaseNum()));
        }
        for (ArchiveFileInfo archiveFileInfo : archiveFileInfos) {
            if (archiveFileInfo == null) continue;
            this.numberGenUtil.pushXmNum(archiveFileInfo.getArId(), Integer.valueOf(archiveFileInfo.getArSort()));
        }
    }

    private void sxArchivesModelExcelImport(MultipartFile file, String type) throws Exception {
        List archivesModels = ExcelUtil.readExcel((MultipartFile)file, MediaArchivesModel.class, (int)1, (int)2);
        if (archivesModels == null || archivesModels.size() <= 0) {
            throw new RuntimeException("[" + file.getOriginalFilename() + "]\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
        }
        archivesModels = archivesModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveRecordInfo> list = new ArrayList<ArchiveRecordInfo>(archivesModels.size());
        for (int i = 0; i < archivesModels.size(); ++i) {
            MediaArchivesModel item = (MediaArchivesModel)((Object)archivesModels.get(i));
            if (StringUtils.isEmpty((String)item.getFileNum()) || StringUtils.isEmpty((String)item.getBoxName())) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u6863\u53f7,\u6848\u5377\u9898\u540d]\u662f\u5426\u586b\u5199\u5b8c\u6574");
            }
            String fileNum = item.getFileNum().trim();
            boolean flag = fileNum.matches(SX_FILE_NUM_EXAMPLE);
            if (Boolean.FALSE == flag) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6863\u53f7\u4e0d\u7b26\u5408\u6807\u51c6,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            ArchiveRecordInfo archiveRecordInfo = new ArchiveRecordInfo();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)archiveRecordInfo));
            archiveRecordInfo.setFileNum(fileNum);
            this.checkStartEndDate(item.getStartEndDate(), archiveRecordInfo, file, i);
            String[] split = fileNum.split("-");
            List<ArchiveCategoryInfo> archiveCategoryInfos = this.categoryInfoService.selectByCode(type, split[2]);
            if (archiveCategoryInfos == null || archiveCategoryInfos.size() <= 0) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6863\u53f7(\u5206\u7c7b\u53f7\u90e8\u5206)\u586b\u5199\u9519\u8bef,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            archiveRecordInfo.setArchiveScope(archiveCategoryInfos.get(0).getId());
            archiveRecordInfo.setCategoryCode(archiveCategoryInfos.get(0).getCode());
            archiveRecordInfo.setArchiveCategory(type);
            archiveRecordInfo.setYear(fileNum.substring(type.length(), fileNum.indexOf("-")));
            archiveRecordInfo.setStorageTime(split[1]);
            archiveRecordInfo.setCaseNum(split[3]);
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            if (StringUtils.isNotEmpty((String)item.getDescriptionTime())) {
                archiveRecordInfo.setDescriptionTime(simpleDateFormat.parse(item.getDescriptionTime()));
            }
            if (StringUtils.isNotEmpty((String)item.getProvide_date())) {
                archiveRecordInfo.setProvide_date(simpleDateFormat.parse(item.getProvide_date()));
            }
            archiveRecordInfo.setCreateId(SecurityUtils.getUserId().toString());
            archiveRecordInfo.setSource("0");
            archiveRecordInfo.setStatus("0");
            archiveRecordInfo.setUpdateTime(DateUtils.getNowDate());
            archiveRecordInfo.setCreateTime(DateUtils.getNowDate());
            list.add(archiveRecordInfo);
        }
        Map<String, ArchiveRecordInfo> stringArchiveRecordInfoMap = this.batchSaveRecordInfoList(list);
        List writFileModels = ExcelUtil.readExcel((MultipartFile)file, MediaFileModel.class, (int)2, (int)2);
        writFileModels = writFileModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveFileInfo> archiveFileInfos = new ArrayList<ArchiveFileInfo>(writFileModels.size());
        if (writFileModels != null && writFileModels.size() > 0) {
            for (int i = 0; i < writFileModels.size(); ++i) {
                SysDept sysDept;
                MediaFileModel tmp = (MediaFileModel)((Object)writFileModels.get(i));
                if (StringUtils.isEmpty((String)tmp.getRecordFileNum()) || StringUtils.isEmpty((String)tmp.getArSort()) || StringUtils.isEmpty((String)tmp.getTitle())) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014\u5377\u5185\u76ee\u5f55\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u6848\u5377\u6863\u53f7,\u5377\u5185\u987a\u5e8f\u53f7,\u6587\u4ef6\u6807\u9898]\u662f\u5426\u586b\u5199\u5b8c\u6574");
                }
                ArchiveFileInfo archiveFileInfo = new ArchiveFileInfo();
                ArchiveRecordInfo archiveRecordInfo = stringArchiveRecordInfoMap.get(tmp.getRecordFileNum().trim());
                if (archiveRecordInfo == null || archiveRecordInfo.getId() == null) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014\u5377\u5185\u76ee\u5f55\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u6863\u6848\u4fe1\u606f\u8bf7\u68c0\u67e5");
                }
                if (tmp.getFileDept() != null && (sysDept = this.sysDeptService.selectDeptById(tmp.getFileDept())) == null) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:2\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u8d23\u4efb\u90e8\u95e8\u586b\u5199\u9519\u8bef,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
                }
                BeanUtils.copyProperties((Object)((Object)tmp), (Object)((Object)archiveFileInfo));
                if (StringUtils.isNotEmpty((String)tmp.getFileDate())) {
                    archiveFileInfo.setFileDate(simpleDateFormat.parse(tmp.getFileDate()));
                }
                archiveFileInfo.setArId(String.valueOf(archiveRecordInfo.getId()));
                archiveFileInfo.setCreateId(SecurityUtils.getUserId().toString());
                archiveFileInfo.setCreateTime(DateUtils.getNowDate());
                archiveFileInfo.setUpdateTime(DateUtils.getNowDate());
                archiveFileInfo.setStatus("0");
                archiveFileInfos.add(archiveFileInfo);
            }
            this.batchSaveFileInfoList(archiveFileInfos);
        }
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (ArchiveRecordInfo archiveRecordInfo : list) {
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                this.numberGenUtil.removeValueByKey(keyValues);
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u6863\u53f7" + archiveRecordInfo.getFileNum() + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            KeyValue keyValue = new KeyValue();
            keyValue.setKey(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear());
            keyValue.setValue(Integer.valueOf(archiveRecordInfo.getCaseNum()));
            keyValues.add(keyValue);
            this.numberGenUtil.pushXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear(), Integer.valueOf(archiveRecordInfo.getCaseNum()));
        }
        for (ArchiveFileInfo archiveFileInfo : archiveFileInfos) {
            if (archiveFileInfo == null) continue;
            this.numberGenUtil.pushXmNum(archiveFileInfo.getArId(), Integer.valueOf(archiveFileInfo.getArSort()));
        }
    }

    private void jjArchivesModelExcelImport(MultipartFile file, String type) throws Exception {
        List archivesModels = ExcelUtil.readExcel((MultipartFile)file, CapitalArchivesModel.class, (int)1, (int)2);
        if (archivesModels == null || archivesModels.size() <= 0) {
            throw new RuntimeException("[" + file.getOriginalFilename() + "]\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
        }
        archivesModels = archivesModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveRecordInfo> list = new ArrayList<ArchiveRecordInfo>(archivesModels.size());
        for (int i = 0; i < archivesModels.size(); ++i) {
            CapitalArchivesModel item = (CapitalArchivesModel)((Object)archivesModels.get(i));
            if (StringUtils.isEmpty((String)item.getStorageTime()) || StringUtils.isEmpty((String)item.getFileNum()) || StringUtils.isEmpty((String)item.getBoxName())) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u4fdd\u7ba1\u671f\u9650,\u6863\u53f7,\u6848\u5377\u9898\u540d]\u662f\u5426\u586b\u5199\u5b8c\u6574");
            }
            String fileNum = item.getFileNum().trim();
            boolean flag = fileNum.matches(JJ_FILE_NUM_EXAMPLE);
            if (Boolean.FALSE == flag) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6863\u53f7\u4e0d\u7b26\u5408\u6807\u51c6,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            ArchiveRecordInfo archiveRecordInfo = new ArchiveRecordInfo();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)archiveRecordInfo));
            archiveRecordInfo.setFileNum(fileNum);
            this.checkStartEndDate(item.getStartEndDate(), archiveRecordInfo, file, i);
            List<ArchiveCategoryInfo> archiveCategoryInfos = this.categoryInfoService.selectByCode(type, fileNum.substring(fileNum.indexOf("-") + 1, fileNum.lastIndexOf("-")));
            if (archiveCategoryInfos == null || archiveCategoryInfos.size() <= 0) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6863\u53f7(\u5206\u7c7b\u53f7\u90e8\u5206)\u586b\u5199\u9519\u8bef,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            archiveRecordInfo.setArchiveScope(archiveCategoryInfos.get(0).getId());
            archiveRecordInfo.setCategoryCode(archiveCategoryInfos.get(0).getCode());
            archiveRecordInfo.setArchiveCategory(type);
            archiveRecordInfo.setProjectNumber(fileNum.substring(archiveRecordInfo.getArchiveCategory().length(), fileNum.indexOf("-")));
            archiveRecordInfo.setCaseNum(fileNum.substring(fileNum.lastIndexOf("-") + 1));
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getProjectNumber() + "-" + archiveRecordInfo.getCategoryCode(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            archiveRecordInfo.setCreateId(SecurityUtils.getUserId().toString());
            archiveRecordInfo.setSource("0");
            archiveRecordInfo.setStatus("0");
            archiveRecordInfo.setUpdateTime(DateUtils.getNowDate());
            archiveRecordInfo.setCreateTime(DateUtils.getNowDate());
            list.add(archiveRecordInfo);
        }
        Map<String, ArchiveRecordInfo> stringArchiveRecordInfoMap = this.batchSaveRecordInfoList(list);
        List writFileModels = ExcelUtil.readExcel((MultipartFile)file, CapitalFileModel.class, (int)2, (int)2);
        writFileModels = writFileModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveFileInfo> archiveFileInfos = new ArrayList<ArchiveFileInfo>(writFileModels.size());
        if (writFileModels != null && writFileModels.size() > 0) {
            for (int i = 0; i < writFileModels.size(); ++i) {
                CapitalFileModel tmp = (CapitalFileModel)((Object)writFileModels.get(i));
                if (StringUtils.isEmpty((String)tmp.getRecordFileNum()) || StringUtils.isEmpty((String)tmp.getArSort()) || StringUtils.isEmpty((String)tmp.getTitle())) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014\u5377\u5185\u76ee\u5f55\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u6848\u5377\u6863\u53f7,\u5377\u5185\u987a\u5e8f\u53f7,\u6587\u4ef6\u6807\u9898]\u662f\u5426\u586b\u5199\u5b8c\u6574");
                }
                ArchiveFileInfo archiveFileInfo = new ArchiveFileInfo();
                ArchiveRecordInfo archiveRecordInfo = stringArchiveRecordInfoMap.get(tmp.getRecordFileNum());
                if (archiveRecordInfo == null || archiveRecordInfo.getId() == null) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014\u5377\u5185\u76ee\u5f55\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u6863\u6848\u4fe1\u606f\u8bf7\u68c0\u67e5");
                }
                BeanUtils.copyProperties((Object)((Object)tmp), (Object)((Object)archiveFileInfo));
                try {
                    if (tmp.getStartEndDate().indexOf("-") <= 0) {
                        if (tmp.getStartEndDate().length() == 6) {
                            archiveFileInfo.setStartDate(simpleDateFormat.parse(tmp.getStartEndDate() + "01"));
                        } else {
                            archiveFileInfo.setStartDate(simpleDateFormat.parse(tmp.getStartEndDate()));
                        }
                    } else {
                        String[] startEnd = tmp.getStartEndDate().split("-");
                        archiveFileInfo.setStartDate(simpleDateFormat.parse(startEnd[0]));
                        archiveFileInfo.setEndDate(simpleDateFormat.parse(startEnd[1]));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014\u5377\u5185\u76ee\u5f55\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u8d77\u6b62\u65e5\u671f\u586b\u5199\u9519\u8bef,\u8bf7\u67e5\u770b\u6a21\u677f\u5e76\u68c0\u67e5\u540e\u63d0\u4ea4");
                }
                if (StringUtils.isNotEmpty((String)tmp.getFileDate())) {
                    archiveFileInfo.setFileDate(simpleDateFormat.parse(tmp.getFileDate()));
                }
                archiveFileInfo.setArId(String.valueOf(archiveRecordInfo.getId()));
                archiveFileInfo.setCreateId(SecurityUtils.getUserId().toString());
                archiveFileInfo.setCreateTime(DateUtils.getNowDate());
                archiveFileInfo.setUpdateTime(DateUtils.getNowDate());
                archiveFileInfo.setStatus("0");
                archiveFileInfos.add(archiveFileInfo);
            }
            this.batchSaveFileInfoList(archiveFileInfos);
        }
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (ArchiveRecordInfo archiveRecordInfo : list) {
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getProjectNumber() + "-" + archiveRecordInfo.getCategoryCode(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                this.numberGenUtil.removeValueByKey(keyValues);
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u6863\u53f7" + archiveRecordInfo.getFileNum() + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            KeyValue keyValue = new KeyValue();
            keyValue.setKey(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getProjectNumber() + "-" + archiveRecordInfo.getCategoryCode());
            keyValue.setValue(Integer.valueOf(archiveRecordInfo.getCaseNum()));
            keyValues.add(keyValue);
            this.numberGenUtil.pushXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getProjectNumber() + "-" + archiveRecordInfo.getCategoryCode(), Integer.valueOf(archiveRecordInfo.getCaseNum()));
        }
        for (ArchiveFileInfo archiveFileInfo : archiveFileInfos) {
            if (archiveFileInfo == null) continue;
            this.numberGenUtil.pushXmNum(archiveFileInfo.getArId(), Integer.valueOf(archiveFileInfo.getArSort()));
        }
    }

    private void zxxmArchivesModelExcelImport(MultipartFile file, String type) throws Exception {
        List archivesModels = ExcelUtil.readExcel((MultipartFile)file, ProjectArchivesModel.class, (int)1, (int)2);
        if (archivesModels == null || archivesModels.size() <= 0) {
            throw new RuntimeException("[" + file.getOriginalFilename() + "]\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
        }
        archivesModels = archivesModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveRecordInfo> list = new ArrayList<ArchiveRecordInfo>(archivesModels.size());
        for (int i = 0; i < archivesModels.size(); ++i) {
            List<ArchiveCategoryInfo> archiveCategoryInfos;
            SysDept sysDept;
            ProjectArchivesModel item = (ProjectArchivesModel)((Object)archivesModels.get(i));
            if (StringUtils.isEmpty((String)item.getStorageTime()) || StringUtils.isEmpty((String)item.getFileNum()) || StringUtils.isEmpty((String)item.getBoxName())) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u4fdd\u7ba1\u671f\u9650,\u6863\u53f7,\u6848\u5377\u9898\u540d]\u662f\u5426\u586b\u5199\u5b8c\u6574");
            }
            String fileNum = item.getFileNum().trim();
            boolean flag = fileNum.matches(ZXXM_FILE_NUM_EXAMPLE);
            if (Boolean.FALSE == flag) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6863\u53f7\u4e0d\u7b26\u5408\u6807\u51c6,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            ArchiveRecordInfo archiveRecordInfo = new ArchiveRecordInfo();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)archiveRecordInfo));
            if (archiveRecordInfo.getDepartment() != null && (sysDept = this.sysDeptService.selectDeptById(archiveRecordInfo.getDepartment())) == null) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u7acb\u5377\u90e8\u95e8\u586b\u5199\u9519\u8bef,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            if (StringUtils.isNotEmpty((String)item.getDescriptionTime())) {
                archiveRecordInfo.setDescriptionTime(simpleDateFormat.parse(item.getDescriptionTime()));
            }
            if ((archiveCategoryInfos = this.categoryInfoService.selectByCode(type, fileNum.substring(fileNum.indexOf("-") + 1, fileNum.lastIndexOf("-")))) == null || archiveCategoryInfos.size() <= 0) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6863\u53f7(\u5206\u7c7b\u53f7\u90e8\u5206)\u586b\u5199\u9519\u8bef,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            archiveRecordInfo.setFileNum(fileNum);
            archiveRecordInfo.setArchiveScope(archiveCategoryInfos.get(0).getId());
            archiveRecordInfo.setCategoryCode(archiveCategoryInfos.get(0).getCode());
            archiveRecordInfo.setArchiveCategory(type);
            archiveRecordInfo.setCaseNum(fileNum.substring(fileNum.lastIndexOf("-") + 1));
            archiveRecordInfo.setProjectNumber(fileNum.substring(archiveRecordInfo.getArchiveCategory().length(), fileNum.indexOf("-")));
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getProjectNumber(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            archiveRecordInfo.setCreateId(SecurityUtils.getUserId().toString());
            archiveRecordInfo.setSource("0");
            archiveRecordInfo.setStatus("0");
            archiveRecordInfo.setUpdateTime(DateUtils.getNowDate());
            archiveRecordInfo.setCreateTime(DateUtils.getNowDate());
            list.add(archiveRecordInfo);
        }
        Map<String, ArchiveRecordInfo> stringArchiveRecordInfoMap = this.batchSaveRecordInfoList(list);
        List writFileModels = ExcelUtil.readExcel((MultipartFile)file, WSFileModel.class, (int)2, (int)2);
        writFileModels = writFileModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveFileInfo> archiveFileInfos = new ArrayList<ArchiveFileInfo>(writFileModels.size());
        if (writFileModels != null && writFileModels.size() > 0) {
            for (int i = 0; i < writFileModels.size(); ++i) {
                WSFileModel tmp = (WSFileModel)((Object)writFileModels.get(i));
                if (StringUtils.isEmpty((String)tmp.getRecordFileNum()) || StringUtils.isEmpty((String)tmp.getArSort()) || StringUtils.isEmpty((String)tmp.getTitle())) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014\u5377\u5185\u76ee\u5f55\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u6848\u5377\u6863\u53f7,\u5377\u5185\u987a\u5e8f\u53f7,\u6587\u4ef6\u6807\u9898]\u662f\u5426\u586b\u5199\u5b8c\u6574");
                }
                ArchiveRecordInfo archiveRecordInfo = stringArchiveRecordInfoMap.get(tmp.getRecordFileNum().trim());
                if (archiveRecordInfo == null || archiveRecordInfo.getId() == null) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014\u5377\u5185\u76ee\u5f55\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u6863\u6848\u4fe1\u606f\u8bf7\u68c0\u67e5");
                }
                ArchiveFileInfo archiveFileInfo = new ArchiveFileInfo();
                BeanUtils.copyProperties((Object)((Object)tmp), (Object)((Object)archiveFileInfo));
                if (tmp.getFileDate() != null) {
                    archiveFileInfo.setFileDate(simpleDateFormat.parse(tmp.getFileDate()));
                }
                if (tmp.getFilingTime() != null) {
                    archiveFileInfo.setFilingTime(simpleDateFormat.parse(tmp.getFilingTime()));
                }
                archiveFileInfo.setArId(String.valueOf(archiveRecordInfo.getId()));
                archiveFileInfo.setCreateId(SecurityUtils.getUserId().toString());
                archiveFileInfo.setCreateTime(DateUtils.getNowDate());
                archiveFileInfo.setUpdateTime(DateUtils.getNowDate());
                archiveFileInfo.setStatus("0");
                archiveFileInfos.add(archiveFileInfo);
            }
            this.batchSaveFileInfoList(archiveFileInfos);
        }
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (ArchiveRecordInfo archiveRecordInfo : list) {
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getProjectNumber(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                this.numberGenUtil.removeValueByKey(keyValues);
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u6863\u53f7" + archiveRecordInfo.getFileNum() + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            KeyValue keyValue = new KeyValue();
            keyValue.setKey(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getProjectNumber());
            keyValue.setValue(Integer.valueOf(archiveRecordInfo.getCaseNum()));
            keyValues.add(keyValue);
            this.numberGenUtil.pushXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getProjectNumber(), Integer.valueOf(archiveRecordInfo.getCaseNum()));
        }
        for (ArchiveFileInfo archiveFileInfo : archiveFileInfos) {
            if (archiveFileInfo == null) continue;
            this.numberGenUtil.pushXmNum(archiveFileInfo.getArId(), Integer.valueOf(archiveFileInfo.getArSort()));
        }
    }

    private void njArchivesModelExcelImport(MultipartFile file, String type) throws Exception {
        List archivesModels = ExcelUtil.readExcel((MultipartFile)file, YearbooksArchivesModel.class, (int)1, (int)2);
        if (archivesModels == null || archivesModels.size() <= 0) {
            throw new RuntimeException("[" + file.getOriginalFilename() + "]\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
        }
        archivesModels = archivesModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveRecordInfo> list = new ArrayList<ArchiveRecordInfo>(archivesModels.size());
        for (int i = 0; i < archivesModels.size(); ++i) {
            YearbooksArchivesModel item = (YearbooksArchivesModel)((Object)archivesModels.get(i));
            if (StringUtils.isEmpty((String)item.getStorageTime()) || StringUtils.isEmpty((String)item.getFileNum()) || StringUtils.isEmpty((String)item.getBoxName())) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u4fdd\u7ba1\u671f\u9650,\u6863\u53f7,\u6848\u5377\u9898\u540d]\u662f\u5426\u586b\u5199\u5b8c\u6574");
            }
            String fileNum = item.getFileNum().trim();
            boolean flag = fileNum.matches(NJ_FILE_NUM_EXAMPLE);
            if (Boolean.FALSE == flag) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6863\u53f7\u4e0d\u7b26\u5408\u6807\u51c6,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            ArchiveRecordInfo archiveRecordInfo = new ArchiveRecordInfo();
            archiveRecordInfo.setArchiveCategory(type);
            archiveRecordInfo.setYear(fileNum.substring(type.length(), fileNum.indexOf("-")));
            List<ArchiveRecordInfo> archiveRecordInfos = this.archiveRecordInfoService.selectArchiveRecordInfoList(archiveRecordInfo);
            if (archiveRecordInfos != null && archiveRecordInfos.size() > 0) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u8be5\u5e74\u5ea6\u5e74\u9274\u6863\u6848\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)archiveRecordInfo));
            archiveRecordInfo.setCaseNum(fileNum.substring(fileNum.lastIndexOf("-") + 1));
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            if (StringUtils.isNotEmpty((String)item.getDescriptionTime())) {
                archiveRecordInfo.setDescriptionTime(simpleDateFormat.parse(item.getDescriptionTime()));
            }
            archiveRecordInfo.setFileNum(fileNum);
            archiveRecordInfo.setCreateId(SecurityUtils.getUserId().toString());
            archiveRecordInfo.setSource("0");
            archiveRecordInfo.setStatus("0");
            archiveRecordInfo.setUpdateTime(DateUtils.getNowDate());
            archiveRecordInfo.setCreateTime(DateUtils.getNowDate());
            list.add(archiveRecordInfo);
        }
        Map<String, ArchiveRecordInfo> stringArchiveRecordInfoMap = this.batchSaveRecordInfoList(list);
        List<CommonFileModel> writFileModels = ExcelUtil.readExcel((MultipartFile)file, CommonFileModel.class, (int)2, (int)2);
        writFileModels = writFileModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveFileInfo> archiveFileInfos = new ArrayList<ArchiveFileInfo>(writFileModels.size());
        this.importFiles(writFileModels, file, stringArchiveRecordInfoMap, archiveFileInfos);
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (ArchiveRecordInfo archiveRecordInfo : list) {
            ArchiveRecordInfo info = new ArchiveRecordInfo();
            info.setArchiveCategory(archiveRecordInfo.getArchiveCategory());
            info.setYear(archiveRecordInfo.getYear());
            List<ArchiveRecordInfo> listInfo = this.archiveRecordInfoService.selectArchiveRecordInfoList(info);
            if (listInfo != null && listInfo.size() > 1) {
                this.numberGenUtil.removeValueByKey(keyValues);
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u6863\u53f7" + archiveRecordInfo.getFileNum() + "]\u8be5\u5e74\u5ea6\u5e74\u9274\u6863\u6848\u5df2\u5b58\u5728,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                this.numberGenUtil.removeValueByKey(keyValues);
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u6863\u53f7" + archiveRecordInfo.getFileNum() + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            KeyValue keyValue = new KeyValue();
            keyValue.setKey(archiveRecordInfo.getArchiveCategory().toUpperCase());
            keyValue.setValue(Integer.valueOf(archiveRecordInfo.getCaseNum()));
            keyValues.add(keyValue);
            this.numberGenUtil.pushXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase(), Integer.valueOf(archiveRecordInfo.getCaseNum()));
        }
        for (ArchiveFileInfo archiveFileInfo : archiveFileInfos) {
            if (archiveFileInfo == null) continue;
            this.numberGenUtil.pushXmNum(archiveFileInfo.getArId(), Integer.valueOf(archiveFileInfo.getArSort()));
        }
    }

    private void zxArchivesModelExcelImport(MultipartFile file, String type) throws Exception {
        List archivesModels = ExcelUtil.readExcel((MultipartFile)file, ZXArchivesModel.class, (int)1, (int)2);
        if (archivesModels == null || archivesModels.size() <= 0) {
            throw new RuntimeException("[" + file.getOriginalFilename() + "]\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
        }
        archivesModels = archivesModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveRecordInfo> list = new ArrayList<ArchiveRecordInfo>(archivesModels.size());
        for (int i = 0; i < archivesModels.size(); ++i) {
            SysDept sysDept;
            ZXArchivesModel item = (ZXArchivesModel)((Object)archivesModels.get(i));
            if (StringUtils.isEmpty((String)item.getFileNum()) || StringUtils.isEmpty((String)item.getBoxName())) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u6863\u53f7,\u6848\u5377\u9898\u540d]\u662f\u5426\u586b\u5199\u5b8c\u6574");
            }
            String fileNum = item.getFileNum().trim();
            boolean flag = fileNum.matches(ZX_FILE_NUM_EXAMPLE);
            if (Boolean.FALSE == flag) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6863\u53f7\u4e0d\u7b26\u5408\u6807\u51c6,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            ArchiveRecordInfo archiveRecordInfo = new ArchiveRecordInfo();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)archiveRecordInfo));
            archiveRecordInfo.setFileNum(fileNum);
            if (archiveRecordInfo.getDepartment() != null && (sysDept = this.sysDeptService.selectDeptById(archiveRecordInfo.getDepartment())) == null) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u7acb\u5377\u90e8\u95e8\u586b\u5199\u9519\u8bef,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            archiveRecordInfo.setCaseNum(fileNum.substring(fileNum.lastIndexOf("-") + 1));
            archiveRecordInfo.setArchiveCategory(type);
            archiveRecordInfo.setYear(fileNum.substring(type.length(), fileNum.indexOf("-")));
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            archiveRecordInfo.setStorageTime(fileNum.substring(fileNum.indexOf("-") + 1, fileNum.lastIndexOf("-")));
            archiveRecordInfo.setCreateId(SecurityUtils.getUserId().toString());
            archiveRecordInfo.setSource("0");
            archiveRecordInfo.setStatus("0");
            archiveRecordInfo.setUpdateTime(DateUtils.getNowDate());
            archiveRecordInfo.setCreateTime(DateUtils.getNowDate());
            list.add(archiveRecordInfo);
        }
        Map<String, ArchiveRecordInfo> stringArchiveRecordInfoMap = this.batchSaveRecordInfoList(list);
        List writFileModels = ExcelUtil.readExcel((MultipartFile)file, WSFileModel.class, (int)2, (int)2);
        writFileModels = writFileModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveFileInfo> archiveFileInfos = new ArrayList<ArchiveFileInfo>(writFileModels.size());
        if (writFileModels != null && writFileModels.size() > 0) {
            for (int i = 0; i < writFileModels.size(); ++i) {
                WSFileModel tmp = (WSFileModel)((Object)writFileModels.get(i));
                if (StringUtils.isEmpty((String)tmp.getRecordFileNum()) || StringUtils.isEmpty((String)tmp.getArSort()) || StringUtils.isEmpty((String)tmp.getTitle())) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014\u5377\u5185\u76ee\u5f55\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u6848\u5377\u6863\u53f7,\u5377\u5185\u987a\u5e8f\u53f7,\u6587\u4ef6\u6807\u9898]\u662f\u5426\u586b\u5199\u5b8c\u6574");
                }
                ArchiveRecordInfo archiveRecordInfo = stringArchiveRecordInfoMap.get(tmp.getRecordFileNum().trim());
                if (archiveRecordInfo == null || archiveRecordInfo.getId() == null) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014\u5377\u5185\u76ee\u5f55\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u6863\u6848\u4fe1\u606f\u8bf7\u68c0\u67e5");
                }
                ArchiveFileInfo archiveFileInfo = new ArchiveFileInfo();
                BeanUtils.copyProperties((Object)((Object)tmp), (Object)((Object)archiveFileInfo));
                if (tmp.getFileDate() != null) {
                    archiveFileInfo.setFileDate(simpleDateFormat.parse(tmp.getFileDate()));
                }
                if (tmp.getFilingTime() != null) {
                    archiveFileInfo.setFilingTime(simpleDateFormat.parse(tmp.getFilingTime()));
                }
                archiveFileInfo.setArId(String.valueOf(archiveRecordInfo.getId()));
                archiveFileInfo.setCreateId(SecurityUtils.getUserId().toString());
                archiveFileInfo.setCreateTime(DateUtils.getNowDate());
                archiveFileInfo.setUpdateTime(DateUtils.getNowDate());
                archiveFileInfo.setStatus("0");
                archiveFileInfos.add(archiveFileInfo);
            }
            this.batchSaveFileInfoList(archiveFileInfos);
        }
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (ArchiveRecordInfo archiveRecordInfo : list) {
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                this.numberGenUtil.removeValueByKey(keyValues);
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u6863\u53f7" + archiveRecordInfo.getFileNum() + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            KeyValue keyValue = new KeyValue();
            keyValue.setKey(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear());
            keyValue.setValue(Integer.valueOf(archiveRecordInfo.getCaseNum()));
            keyValues.add(keyValue);
            this.numberGenUtil.pushXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear(), Integer.valueOf(archiveRecordInfo.getCaseNum()));
        }
        for (ArchiveFileInfo archiveFileInfo : archiveFileInfos) {
            if (archiveFileInfo == null) continue;
            this.numberGenUtil.pushXmNum(archiveFileInfo.getArId(), Integer.valueOf(archiveFileInfo.getArSort()));
        }
    }

    private void swArchivesModelExcelImport(MultipartFile file, String type) throws Exception {
        List archivesModels = ExcelUtil.readExcel((MultipartFile)file, WTArchivesMdel.class, (int)1, (int)2);
        if (archivesModels == null || archivesModels.size() <= 0) {
            throw new RuntimeException("[" + file.getOriginalFilename() + "]\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
        }
        archivesModels = archivesModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveRecordInfo> list = new ArrayList<ArchiveRecordInfo>(archivesModels.size());
        for (int i = 0; i < archivesModels.size(); ++i) {
            WTArchivesMdel item = (WTArchivesMdel)((Object)archivesModels.get(i));
            if (StringUtils.isEmpty((String)item.getFileNum()) || StringUtils.isEmpty((String)item.getBoxName())) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u6863\u53f7,\u8bc1\u4e66\u540d\u79f0]\u662f\u5426\u586b\u5199\u5b8c\u6574");
            }
            String fileNum = item.getFileNum().trim();
            boolean flag = fileNum.matches(SW_FILE_NUM_EXAMPLE);
            if (Boolean.FALSE == flag) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6863\u53f7\u4e0d\u7b26\u5408\u6807\u51c6,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            ArchiveRecordInfo archiveRecordInfo = new ArchiveRecordInfo();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)archiveRecordInfo));
            if (StringUtils.isNotEmpty((String)item.getDescriptionTime())) {
                archiveRecordInfo.setDescriptionTime(simpleDateFormat.parse(item.getDescriptionTime()));
            }
            archiveRecordInfo.setFileNum(fileNum);
            archiveRecordInfo.setCaseNum(fileNum.substring(fileNum.lastIndexOf("-") + 1));
            archiveRecordInfo.setArchiveCategory(type);
            archiveRecordInfo.setYear(fileNum.substring(fileNum.indexOf("-") + 1, fileNum.indexOf("-") + 5));
            archiveRecordInfo.setStorageTime(fileNum.substring(fileNum.indexOf("-") + 6, fileNum.lastIndexOf("-")));
            List<ArchiveCategoryInfo> archiveCategoryInfos = this.categoryInfoService.selectByCode(type, fileNum.substring(0, fileNum.indexOf("-")));
            if (archiveCategoryInfos == null || archiveCategoryInfos.size() <= 0) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6863\u53f7(\u5206\u7c7b\u53f7\u90e8\u5206)\u586b\u5199\u9519\u8bef,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            archiveRecordInfo.setArchiveScope(archiveCategoryInfos.get(0).getId());
            archiveRecordInfo.setCategoryCode(archiveCategoryInfos.get(0).getCode());
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getCategoryCode(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            archiveRecordInfo.setCreateId(SecurityUtils.getUserId().toString());
            archiveRecordInfo.setSource("0");
            archiveRecordInfo.setStatus("0");
            archiveRecordInfo.setUpdateTime(DateUtils.getNowDate());
            archiveRecordInfo.setCreateTime(DateUtils.getNowDate());
            list.add(archiveRecordInfo);
        }
        Map<String, ArchiveRecordInfo> stringArchiveRecordInfoMap = this.batchSaveRecordInfoList(list);
        List<CommonFileModel> writFileModels = ExcelUtil.readExcel((MultipartFile)file, CommonFileModel.class, (int)2, (int)2);
        writFileModels = writFileModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveFileInfo> archiveFileInfos = new ArrayList<ArchiveFileInfo>(writFileModels.size());
        this.importFiles(writFileModels, file, stringArchiveRecordInfoMap, archiveFileInfos);
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (ArchiveRecordInfo archiveRecordInfo : list) {
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getCategoryCode(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                this.numberGenUtil.removeValueByKey(keyValues);
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u6863\u53f7" + archiveRecordInfo.getFileNum() + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            KeyValue keyValue = new KeyValue();
            keyValue.setKey(archiveRecordInfo.getCategoryCode());
            keyValue.setValue(Integer.valueOf(archiveRecordInfo.getCaseNum()));
            keyValues.add(keyValue);
            this.numberGenUtil.pushXmNum(archiveRecordInfo.getCategoryCode(), Integer.valueOf(archiveRecordInfo.getCaseNum()));
        }
        for (ArchiveFileInfo archiveFileInfo : archiveFileInfos) {
            if (archiveFileInfo == null) continue;
            this.numberGenUtil.pushXmNum(archiveFileInfo.getArId(), Integer.valueOf(archiveFileInfo.getArSort()));
        }
    }

    private void jydaArchivesModelExcelImport(MultipartFile file, String type) throws Exception {
        List archivesModels = ExcelUtil.readExcel((MultipartFile)file, JYWJArchivesModel.class, (int)1, (int)2);
        if (archivesModels == null || archivesModels.size() <= 0) {
            throw new RuntimeException("[" + file.getOriginalFilename() + "]\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
        }
        archivesModels = archivesModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveRecordInfo> list = new ArrayList<ArchiveRecordInfo>(archivesModels.size());
        for (int i = 0; i < archivesModels.size(); ++i) {
            SysDept sysDept;
            JYWJArchivesModel item = (JYWJArchivesModel)((Object)archivesModels.get(i));
            if (StringUtils.isEmpty((String)item.getFileNum()) || StringUtils.isEmpty((String)item.getBoxName())) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u6863\u53f7,\u6848\u5377\u9898\u540d]\u662f\u5426\u586b\u5199\u5b8c\u6574");
            }
            String fileNum = item.getFileNum().trim();
            boolean flag = fileNum.matches(JYWJ_FILE_NUM_EXAMPLE);
            if (Boolean.FALSE == flag) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6863\u53f7\u4e0d\u7b26\u5408\u6807\u51c6,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            ArchiveRecordInfo archiveRecordInfo = new ArchiveRecordInfo();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)archiveRecordInfo));
            if (archiveRecordInfo.getDepartment() != null && (sysDept = this.sysDeptService.selectDeptById(archiveRecordInfo.getDepartment())) == null) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u7acb\u5377\u90e8\u95e8\u586b\u5199\u9519\u8bef,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            archiveRecordInfo.setCaseNum(fileNum.substring(fileNum.lastIndexOf("-") + 1));
            archiveRecordInfo.setArchiveCategory(type);
            archiveRecordInfo.setYear(fileNum.substring(0, fileNum.indexOf("-")));
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            if (StringUtils.isNotEmpty((String)item.getDescriptionTime())) {
                archiveRecordInfo.setDescriptionTime(simpleDateFormat.parse(item.getDescriptionTime()));
            }
            archiveRecordInfo.setFileNum(fileNum);
            archiveRecordInfo.setStorageTime(fileNum.substring(fileNum.indexOf("-") + 1, fileNum.lastIndexOf("-")));
            archiveRecordInfo.setCreateId(SecurityUtils.getUserId().toString());
            archiveRecordInfo.setSource("0");
            archiveRecordInfo.setStatus("0");
            archiveRecordInfo.setUpdateTime(DateUtils.getNowDate());
            archiveRecordInfo.setCreateTime(DateUtils.getNowDate());
            list.add(archiveRecordInfo);
        }
        Map<String, ArchiveRecordInfo> stringArchiveRecordInfoMap = this.batchSaveRecordInfoList(list);
        List writFileModels = ExcelUtil.readExcel((MultipartFile)file, CommonFileModel.class, (int)2, (int)2);
        ArrayList<ArchiveFileInfo> archiveFileInfos = new ArrayList<ArchiveFileInfo>(writFileModels.size());
        this.importFiles(writFileModels, file, stringArchiveRecordInfoMap, archiveFileInfos);
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (ArchiveRecordInfo archiveRecordInfo : list) {
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear(), Integer.valueOf(archiveRecordInfo.getCaseNum())).booleanValue()) {
                this.numberGenUtil.removeValueByKey(keyValues);
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u6863\u53f7" + archiveRecordInfo.getFileNum() + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            KeyValue keyValue = new KeyValue();
            keyValue.setKey(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear());
            keyValue.setValue(Integer.valueOf(archiveRecordInfo.getCaseNum()));
            keyValues.add(keyValue);
            this.numberGenUtil.pushXmNum(archiveRecordInfo.getArchiveCategory().toUpperCase() + archiveRecordInfo.getYear(), Integer.valueOf(archiveRecordInfo.getCaseNum()));
        }
        for (ArchiveFileInfo archiveFileInfo : archiveFileInfos) {
            if (archiveFileInfo == null) continue;
            this.numberGenUtil.pushXmNum(archiveFileInfo.getArId(), Integer.valueOf(archiveFileInfo.getArSort()));
        }
    }

    private void wsArchivesModelExcelImport(MultipartFile file, String type) throws Exception {
        ArchiveRecordInfo archiveRecordInfo2;
        List writArchivesModels = ExcelUtil.readExcel((MultipartFile)file, WritArchivesModel.class, (int)1, (int)2);
        if (writArchivesModels == null || writArchivesModels.size() <= 0) {
            throw new RuntimeException("[" + file.getOriginalFilename() + "]\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
        }
        writArchivesModels = writArchivesModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveRecordInfo> list = new ArrayList<ArchiveRecordInfo>(writArchivesModels.size());
        for (int i = 0; i < writArchivesModels.size(); ++i) {
            SysDept sysDept;
            WritArchivesModel writArchivesModel = (WritArchivesModel)((Object)writArchivesModels.get(i));
            if (StringUtils.isEmpty((String)writArchivesModel.getYear()) || StringUtils.isEmpty((String)writArchivesModel.getStorageTime()) || StringUtils.isEmpty((String)writArchivesModel.getFileNum()) || StringUtils.isEmpty((String)writArchivesModel.getBoxName())) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u5e74\u5ea6,\u4fdd\u7ba1\u671f\u9650,\u6863\u53f7,\u6848\u5377\u9898\u540d]\u662f\u5426\u586b\u5199\u5b8c\u6574");
            }
            String fileNum = writArchivesModel.getFileNum().trim();
            boolean flag = fileNum.matches(WS_FILE_NUM_EXAMPLE);
            boolean historyFlag = fileNum.matches(WS_HISTORY_NUM_EXAMPLE);
            if (Boolean.FALSE == flag && Boolean.FALSE == historyFlag) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6863\u53f7\u4e0d\u7b26\u5408\u6807\u51c6,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            archiveRecordInfo2 = new ArchiveRecordInfo();
            BeanUtils.copyProperties((Object)((Object)writArchivesModel), (Object)((Object)archiveRecordInfo2));
            archiveRecordInfo2.setFileNum(fileNum);
            this.checkStartEndDate(writArchivesModel.getStartEndDate(), archiveRecordInfo2, file, i);
            if (archiveRecordInfo2.getDepartment() != null && (sysDept = this.sysDeptService.selectDeptById(archiveRecordInfo2.getDepartment())) == null) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u7acb\u5377\u90e8\u95e8\u586b\u5199\u9519\u8bef,\u8bf7\u67e5\u770b\u6a21\u677f\u5e76\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            archiveRecordInfo2.setCaseNum(fileNum.substring(fileNum.lastIndexOf("-") + 1));
            archiveRecordInfo2.setArchiveCategory(type);
            if (flag && this.numberGenUtil.selectXmNum(archiveRecordInfo2.getArchiveCategory().toUpperCase() + archiveRecordInfo2.getYear(), Integer.valueOf(archiveRecordInfo2.getCaseNum())).booleanValue()) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            archiveRecordInfo2.setCreateId(SecurityUtils.getUserId().toString());
            archiveRecordInfo2.setSource("0");
            archiveRecordInfo2.setStatus("0");
            archiveRecordInfo2.setUpdateTime(DateUtils.getNowDate());
            archiveRecordInfo2.setCreateTime(DateUtils.getNowDate());
            list.add(archiveRecordInfo2);
        }
        Map<String, ArchiveRecordInfo> stringArchiveRecordInfoMap = this.batchSaveRecordInfoList(list);
        List writFileModels = ExcelUtil.readExcel((MultipartFile)file, WSFileModel.class, (int)2, (int)2);
        writFileModels = writFileModels.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveFileInfo> archiveFileInfos = new ArrayList<ArchiveFileInfo>(writFileModels.size());
        if (writFileModels != null && writFileModels.size() > 0) {
            for (int i = 0; i < writFileModels.size(); ++i) {
                WSFileModel tmp = (WSFileModel)((Object)writFileModels.get(i));
                if (StringUtils.isEmpty((String)tmp.getRecordFileNum()) || StringUtils.isEmpty((String)tmp.getArSort()) || StringUtils.isEmpty((String)tmp.getTitle())) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014\u5377\u5185\u76ee\u5f55\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u6848\u5377\u6863\u53f7,\u5377\u5185\u987a\u5e8f\u53f7,\u6587\u4ef6\u6807\u9898]\u662f\u5426\u586b\u5199\u5b8c\u6574");
                }
                archiveRecordInfo2 = stringArchiveRecordInfoMap.get(tmp.getRecordFileNum().trim());
                if (archiveRecordInfo2 == null || archiveRecordInfo2.getId() == null) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014\u5377\u5185\u76ee\u5f55\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u6863\u6848\u4fe1\u606f\u8bf7\u68c0\u67e5");
                }
                ArchiveFileInfo archiveFileInfo = new ArchiveFileInfo();
                BeanUtils.copyProperties((Object)((Object)tmp), (Object)((Object)archiveFileInfo));
                if (tmp.getFileDate() != null) {
                    archiveFileInfo.setFileDate(simpleDateFormat.parse(tmp.getFileDate()));
                }
                if (tmp.getFilingTime() != null) {
                    archiveFileInfo.setFilingTime(simpleDateFormat.parse(tmp.getFilingTime()));
                }
                archiveFileInfo.setArId(String.valueOf(archiveRecordInfo2.getId()));
                archiveFileInfo.setCreateId(SecurityUtils.getUserId().toString());
                archiveFileInfo.setCreateTime(DateUtils.getNowDate());
                archiveFileInfo.setUpdateTime(DateUtils.getNowDate());
                archiveFileInfo.setStatus("0");
                archiveFileInfos.add(archiveFileInfo);
            }
            this.batchSaveFileInfoList(archiveFileInfos);
        }
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (ArchiveRecordInfo archiveRecordInfo2 : list) {
            if (!archiveRecordInfo2.getFileNum().matches(WS_FILE_NUM_EXAMPLE)) continue;
            if (this.numberGenUtil.selectXmNum(archiveRecordInfo2.getArchiveCategory().toUpperCase() + archiveRecordInfo2.getYear(), Integer.valueOf(archiveRecordInfo2.getCaseNum())).booleanValue()) {
                this.numberGenUtil.removeValueByKey(keyValues);
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u6863\u53f7" + archiveRecordInfo2.getFileNum() + "]\u6839\u636e\u6863\u53f7\u751f\u6210\u89c4\u5219,\u7cfb\u7edf\u5df2\u5b58\u5728\u76f8\u540c\u6d41\u6c34\u53f7,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            KeyValue keyValue = new KeyValue();
            keyValue.setKey(archiveRecordInfo2.getArchiveCategory().toUpperCase() + archiveRecordInfo2.getYear());
            keyValue.setValue(Integer.valueOf(archiveRecordInfo2.getCaseNum()));
            keyValues.add(keyValue);
            this.numberGenUtil.pushXmNum(archiveRecordInfo2.getArchiveCategory().toUpperCase() + archiveRecordInfo2.getYear(), Integer.valueOf(archiveRecordInfo2.getCaseNum()));
        }
        for (ArchiveFileInfo archiveFileInfo : archiveFileInfos) {
            if (archiveFileInfo == null) continue;
            this.numberGenUtil.pushXmNum(archiveFileInfo.getArId(), Integer.valueOf(archiveFileInfo.getArSort()));
        }
    }

    private void dayjArchivesModelExcelImport(MultipartFile file, String type) throws Exception {
        List models = ExcelUtil.readExcel((MultipartFile)file, YJJLArchivesModel.class, (int)1, (int)2);
        if (models == null || models.size() <= 0) {
            throw new RuntimeException("[" + file.getOriginalFilename() + "]\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
        }
        models = models.stream().distinct().collect(Collectors.toList());
        ArrayList<ArchiveRecordInfo> list = new ArrayList<ArchiveRecordInfo>(models.size());
        for (int i = 0; i < models.size(); ++i) {
            SysDept sysDept;
            YJJLArchivesModel item = (YJJLArchivesModel)((Object)models.get(i));
            ArchiveRecordInfo archiveRecordInfo = new ArchiveRecordInfo();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)archiveRecordInfo));
            if (archiveRecordInfo.getDepartment() != null && (sysDept = this.sysDeptService.selectDeptById(archiveRecordInfo.getDepartment())) == null) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u79fb\u4ea4\u90e8\u95e8\u586b\u5199\u9519\u8bef,\u8bf7\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
            if (StringUtils.isNotEmpty((String)item.getDescriptionTime())) {
                archiveRecordInfo.setDescriptionTime(simpleDateFormat.parse(item.getDescriptionTime()));
            }
            archiveRecordInfo.setArchiveCategory(type);
            archiveRecordInfo.setCreateId(SecurityUtils.getUserId().toString());
            archiveRecordInfo.setSource("0");
            archiveRecordInfo.setStatus("0");
            archiveRecordInfo.setUpdateTime(DateUtils.getNowDate());
            archiveRecordInfo.setCreateTime(DateUtils.getNowDate());
            list.add(archiveRecordInfo);
        }
        this.batchSaveRecordInfoList(list);
    }

    private void importFiles(List<CommonFileModel> fileModels, MultipartFile file, Map<String, ArchiveRecordInfo> stringArchiveRecordInfoMap, ArrayList<ArchiveFileInfo> archiveFileInfos) throws Exception {
        if (fileModels != null && fileModels.size() > 0) {
            for (int i = 0; i < fileModels.size(); ++i) {
                CommonFileModel tmp = fileModels.get(i);
                if (StringUtils.isEmpty((String)tmp.getRecordFileNum()) || StringUtils.isEmpty((String)tmp.getArSort()) || StringUtils.isEmpty((String)tmp.getTitle())) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014\u5377\u5185\u76ee\u5f55\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574,\u8bf7\u68c0\u67e5[\u6848\u5377\u6863\u53f7,\u5377\u5185\u987a\u5e8f\u53f7,\u6587\u4ef6\u6807\u9898]\u662f\u5426\u586b\u5199\u5b8c\u6574");
                }
                ArchiveFileInfo archiveFileInfo = new ArchiveFileInfo();
                ArchiveRecordInfo archiveRecordInfo = stringArchiveRecordInfoMap.get(tmp.getRecordFileNum().trim());
                if (archiveRecordInfo == null || archiveRecordInfo.getId() == null) {
                    throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014\u5377\u5185\u76ee\u5f55\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684\u6863\u6848\u4fe1\u606f\u8bf7\u68c0\u67e5");
                }
                BeanUtils.copyProperties((Object)((Object)tmp), (Object)((Object)archiveFileInfo));
                if (StringUtils.isNotEmpty((String)tmp.getFileDate())) {
                    archiveFileInfo.setFileDate(simpleDateFormat.parse(tmp.getFileDate()));
                }
                archiveFileInfo.setArId(String.valueOf(archiveRecordInfo.getId()));
                archiveFileInfo.setCreateId(SecurityUtils.getUserId().toString());
                archiveFileInfo.setCreateTime(DateUtils.getNowDate());
                archiveFileInfo.setUpdateTime(DateUtils.getNowDate());
                archiveFileInfo.setStatus("0");
                archiveFileInfos.add(archiveFileInfo);
            }
            this.batchSaveFileInfoList(archiveFileInfos);
        }
    }

    private static boolean checkObjFieldIsNull(Object obj) throws IllegalAccessException {
        boolean flag = false;
        for (Field f : obj.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            if (f.get(obj) != null && !"".equals(f.get(obj))) continue;
            if (f.getName().equals("descriptionTime") || f.getName().equals("remark") || f.getName().equals("cabinetNumber") || f.getName().equals("department") || f.getName().equals("startDate") || f.getName().equals("endDate") || f.getName().equals("receiveNum") || f.getName().equals("keyWords") || f.getName().equals("underTaker") || f.getName().equals("underUser") || f.getName().equals("createUser") || f.getName().equals("filingTime") || f.getName().equals("country") || f.getName().equals("partner") || f.getName().equals("buildingNumber") || f.getName().equals("major") || f.getName().equals("ownerName") || f.getName().equals("searchType") || f.getName().equals("type") || f.getName().equals("fileDate") || f.getName().equals("issuingUnit") || f.getName().equals("catalog_number") || f.getName().equals("copies") || f.getName().equals("location_num") || f.getName().equals("explain_des") || f.getName().equals("project_name") || f.getName().equals("micro_no") || f.getName().equals("piece_nums") || f.getName().equals("drawing_nums") || f.getName().equals("photo_nums") || f.getName().equals("disc_number") || f.getName().equals("original_path") || f.getName().equals("provide_date") || f.getName().equals("provide_user") || f.getName().equals("photo_no") || f.getName().equals("negative_no") || f.getName().equals("see_no") || f.getName().equals("boxNum")) {
                flag = false;
                continue;
            }
            flag = true;
            break;
        }
        return flag;
    }

    private Map<String, ArchiveRecordInfo> batchSaveRecordInfoList(List<ArchiveRecordInfo> archiveRecordInfoList) {
        HashMap<String, ArchiveRecordInfo> stringArchiveRecordInfoHashMap = new HashMap<String, ArchiveRecordInfo>();
        List<ArchiveRecordInfo> archiveRecordInfos = this.archiveRecordInfoService.batchSaveRecordInfoList(archiveRecordInfoList);
        for (ArchiveRecordInfo archiveRecordInfo : archiveRecordInfos) {
            stringArchiveRecordInfoHashMap.put(archiveRecordInfo.getFileNum(), archiveRecordInfo);
        }
        return stringArchiveRecordInfoHashMap;
    }

    private void batchSaveFileInfoList(List<ArchiveFileInfo> archiveFileInfoList) {
        this.archiveFileInfoService.batchSaveFileInfoList(archiveFileInfoList);
    }

    public void checkStartEndDate(String startEndDate, ArchiveRecordInfo archiveRecordInfo, MultipartFile file, int i) {
        SimpleDateFormat simpleDateFormat = null;
        String commonFormat = "yyyyMMdd";
        if (StringUtils.isNotEmpty((String)startEndDate)) {
            try {
                if (startEndDate.indexOf("-") <= 0) {
                    simpleDateFormat = new SimpleDateFormat(commonFormat.substring(0, startEndDate.length()));
                    archiveRecordInfo.setStartDate(simpleDateFormat.parse(startEndDate));
                } else {
                    String[] startEnd = startEndDate.split("-");
                    int length = startEnd[0].length() >= startEnd[1].length() ? startEnd[0].length() : startEnd[1].length();
                    simpleDateFormat = new SimpleDateFormat(commonFormat.substring(0, length));
                    archiveRecordInfo.setStartDate(simpleDateFormat.parse(startEnd[0]));
                    archiveRecordInfo.setEndDate(simpleDateFormat.parse(startEnd[1]));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("[" + file.getOriginalFilename() + "\u2014\u2014Sheet:1\u2014\u2014\u884c\u53f7" + (i + 3) + "]\u8d77\u6b62\u65e5\u671f\u586b\u5199\u9519\u8bef,\u8bf7\u67e5\u770b\u6a21\u677f\u5e76\u68c0\u67e5\u540e\u63d0\u4ea4");
            }
        }
    }

    @Override
    public AjaxResult hookUpAttachments(MultipartFile mulFile, String type) {
        String path = null;
        String originalFilename = mulFile.getOriginalFilename();
        String originalFilenameSubStr = originalFilename.substring(0, originalFilename.lastIndexOf("."));
        try {
            Object item;
            if (!originalFilename.endsWith("zip") && !originalFilename.endsWith("rar")) {
                throw new Exception("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef,\u53ea\u80fd\u63a5\u6536zip/rar\u683c\u5f0f\u6587\u4ef6");
            }
            Long fileId = null;
            String url = null;
            if (RECORD_TYPE.equals(type)) {
                ArchiveRecordInfo archiveRecordInfo = new ArchiveRecordInfo();
                archiveRecordInfo.setAppendixAddress(originalFilenameSubStr);
                List<ArchiveRecordInfo> recordInfos = this.archiveRecordInfoService.selectArchiveRecordInfoList(archiveRecordInfo);
                if (recordInfos == null || recordInfos.size() <= 0) {
                    throw new Exception("\u627e\u4e0d\u5230[" + originalFilenameSubStr + "]\u7684\u9644\u4ef6\u5730\u5740,\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5.");
                }
                if (recordInfos.size() > 1) {
                    throw new Exception("\u627e\u5230\u591a\u4e2a[" + originalFilenameSubStr + "]\u7684\u9644\u4ef6\u5730\u5740,\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5.");
                }
                item = recordInfos.get(0);
                fileId = ((ArchiveRecordInfo)((Object)item)).getId();
                url = "/" + ((ArchiveRecordInfo)((Object)item)).getArchiveCategory() + "/" + ((ArchiveRecordInfo)((Object)item)).getStorageTime() + "/\u6848\u5377-" + ((ArchiveRecordInfo)((Object)item)).getId() + "/" + DateUtils.datePath();
            } else {
                FileSearchVo archiveFileInfo = new FileSearchVo();
                archiveFileInfo.setAppendixAddress(originalFilenameSubStr);
                List<FileSearchVo> fileInfoList = this.archiveFileInfoService.fileSearchListByAppendixAddress(archiveFileInfo);
                if (fileInfoList == null || fileInfoList.size() <= 0) {
                    throw new Exception("\u627e\u4e0d\u5230[" + originalFilenameSubStr + "]\u7684\u9644\u4ef6\u5730\u5740,\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5.");
                }
                if (fileInfoList.size() > 1) {
                    throw new Exception("\u627e\u5230\u591a\u4e2a[" + originalFilenameSubStr + "]\u7684\u9644\u4ef6\u5730\u5740,\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5.");
                }
                item = fileInfoList.get(0);
                fileId = ((FileSearchVo)item).getId();
                url = "/" + ((FileSearchVo)item).getArchiveCategory() + "/" + ((FileSearchVo)item).getRecordStorageTime() + "/\u6848\u5377-" + ((FileSearchVo)item).getRecordId() + "/" + DateUtils.datePath() + "/" + ((FileSearchVo)item).getArSort();
            }
            File zipFile = FileUtils.multipartFileToFile(mulFile);
            path = zipFile.getParent() + File.separator + "upload";
            ArrayList<File> fileList = new ArrayList<File>();
            List<File> files = UnPackeUtil.unPackZip(fileList, zipFile, path);
            String finallyPath = ArchiveUploadConfig.getPath() + url;
            File fileOut = new File(finallyPath);
            if (!fileOut.exists()) {
                fileOut.mkdirs();
            }
            for (File file : files) {
                File dfile = new File(fileOut.getPath() + "/" + file.getName());
                ArchiveImportServiceImpl.copyFile(file, dfile);
                FileUploadList fileUploadList = new FileUploadList();
                fileUploadList.setFileId(fileId);
                fileUploadList.setCreateId(SecurityUtils.getUserId());
                fileUploadList.setCreateTime(LocalDateTime.now());
                fileUploadList.setPath(url + "/" + dfile.getName());
                fileUploadList.setFileName(dfile.getName());
                fileUploadList.setSuffixType(dfile.getName().substring(dfile.getName().lastIndexOf(".") + 1));
                fileUploadList.setFileType(RECORD_TYPE.equals(type) ? RECORD_TYPE : FILE_TYPE);
                this.fileUploadListService.insertFileUploadList(fileUploadList);
            }
            ArchivesHkHistory archivesHkHistory = new ArchivesHkHistory();
            archivesHkHistory.setAppendixAddress(originalFilenameSubStr);
            archivesHkHistory.setSaveFlag("0");
            archivesHkHistory.setRemark(RECORD_TYPE.equals(type) ? "\u6863\u6848\u6302\u63a5" : "\u6587\u4ef6\u6302\u63a5");
            this.archivesHkHistoryService.insertArchivesHkHistory(archivesHkHistory);
        }
        catch (Exception e) {
            e.printStackTrace();
            ArchivesHkHistory archivesHkHistory = new ArchivesHkHistory();
            archivesHkHistory.setAppendixAddress(originalFilenameSubStr);
            archivesHkHistory.setSaveFlag("1");
            archivesHkHistory.setRemark((RECORD_TYPE.equals(type) ? "[\u6863\u6848\u6302\u63a5]:" : "[\u6587\u4ef6\u6302\u63a5]:") + e.getMessage());
            this.archivesHkHistoryService.insertArchivesHkHistory(archivesHkHistory);
            return AjaxResult.error((String)e.getMessage());
        }
        return AjaxResult.success();
    }

    public static void copyFile(File source, File dfile) throws IOException {
        int len;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        fis = new FileInputStream(source);
        if (!dfile.exists()) {
            dfile.createNewFile();
        }
        fos = new FileOutputStream(dfile);
        byte[] b = new byte[1024];
        while ((len = fis.read(b)) != -1) {
            fos.write(b, 0, len);
        }
        fos.close();
        fis.close();
    }

    public void uploadfile() {
    }

    public Map<String, List<File>> getFils(File file, Map<String, List<File>> map) {
        if (file.isDirectory()) {
            for (File listFile : file.listFiles()) {
                this.getFils(listFile, map);
            }
        } else {
            String parent = file.getParent();
            String[] split = parent.split("\\\\");
            String name = split[split.length - 1];
            List list = map.getOrDefault(name, new ArrayList());
            list.add(file);
            map.put(name, list);
        }
        return map;
    }
}

