/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.archives.controller;

import com.ruoyi.archives.domain.ArchivesHkHistory;
import com.ruoyi.archives.service.IArchivesHkHistoryService;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/archives/history"})
public class ArchivesHkHistoryController
extends BaseController {
    @Autowired
    private IArchivesHkHistoryService archivesHkHistoryService;

    @PreAuthorize(value="@ss.hasPermi('system:history:list')")
    @GetMapping(value={"/list"})
    public TableDataInfo list(ArchivesHkHistory archivesHkHistory) {
        this.startPage();
        List<ArchivesHkHistory> list = this.archivesHkHistoryService.selectArchivesHkHistoryList(archivesHkHistory);
        return this.getDataTable(list);
    }

    @PreAuthorize(value="@ss.hasPermi('system:history:export')")
    @Log(title="\u6302\u63a5\u5386\u53f2", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/export"})
    public AjaxResult export(ArchivesHkHistory archivesHkHistory) {
        List<ArchivesHkHistory> list = this.archivesHkHistoryService.selectArchivesHkHistoryList(archivesHkHistory);
        ExcelUtil util = new ExcelUtil(ArchivesHkHistory.class);
        return util.exportExcel(list, "history");
    }

    @PreAuthorize(value="@ss.hasPermi('system:history:query')")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)((Object)this.archivesHkHistoryService.selectArchivesHkHistoryById(id)));
    }

    @PreAuthorize(value="@ss.hasPermi('system:history:add')")
    @Log(title="\u6302\u63a5\u5386\u53f2", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ArchivesHkHistory archivesHkHistory) {
        return this.toAjax(this.archivesHkHistoryService.insertArchivesHkHistory(archivesHkHistory));
    }

    @PreAuthorize(value="@ss.hasPermi('system:history:edit')")
    @Log(title="\u6302\u63a5\u5386\u53f2", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ArchivesHkHistory archivesHkHistory) {
        return this.toAjax(this.archivesHkHistoryService.updateArchivesHkHistory(archivesHkHistory));
    }

    @PreAuthorize(value="@ss.hasPermi('system:history:remove')")
    @Log(title="\u6302\u63a5\u5386\u53f2", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.archivesHkHistoryService.deleteArchivesHkHistoryByIds(ids));
    }
}

