/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.archives.controller;

import com.ruoyi.archives.domain.ArchiveCategoryInfo;
import com.ruoyi.archives.service.IArchiveCategoryInfoService;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/archives/categoryInfo"})
public class ArchiveCategoryInfoController
extends BaseController {
    @Autowired
    private IArchiveCategoryInfoService archiveCategoryInfoService;

    @PreAuthorize(value="@ss.hasPermi('categoryInfo:info:list')")
    @GetMapping(value={"/list"})
    public AjaxResult list(ArchiveCategoryInfo archiveCategoryInfo) {
        List<ArchiveCategoryInfo> categoryInfoList = this.archiveCategoryInfoService.selectDeptList(archiveCategoryInfo);
        return AjaxResult.success(categoryInfoList);
    }

    @PreAuthorize(value="@ss.hasPermi('categoryInfo:info:export')")
    @Log(title="\u7c7b\u76ee\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @GetMapping(value={"/export"})
    public AjaxResult export(ArchiveCategoryInfo archiveCategoryInfo) {
        List<ArchiveCategoryInfo> list = this.archiveCategoryInfoService.selectArchiveCategoryInfoList(archiveCategoryInfo);
        ExcelUtil util = new ExcelUtil(ArchiveCategoryInfo.class);
        return util.exportExcel(list, "info");
    }

    @PreAuthorize(value="@ss.hasPermi('categoryInfo:info:query')")
    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)((Object)this.archiveCategoryInfoService.selectArchiveCategoryInfoById(id)));
    }

    @PreAuthorize(value="@ss.hasPermi('categoryInfo:info:add')")
    @Log(title="\u7c7b\u76ee\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ArchiveCategoryInfo archiveCategoryInfo) {
        archiveCategoryInfo.setCreateId(SecurityUtils.getUserId().toString());
        return this.toAjax(this.archiveCategoryInfoService.insertArchiveCategoryInfo(archiveCategoryInfo));
    }

    @PreAuthorize(value="@ss.hasPermi('categoryInfo:info:edit')")
    @Log(title="\u7c7b\u76ee\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ArchiveCategoryInfo archiveCategoryInfo) {
        return this.toAjax(this.archiveCategoryInfoService.updateArchiveCategoryInfo(archiveCategoryInfo));
    }

    @PreAuthorize(value="@ss.hasPermi('categoryInfo:info:remove')")
    @Log(title="\u7c7b\u76ee\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable String[] ids) {
        return this.toAjax(this.archiveCategoryInfoService.deleteArchiveCategoryInfoByIds(ids));
    }

    @GetMapping(value={"/list/exclude/{id}"})
    public AjaxResult excludeChild(@PathVariable(value="id", required=false) String id) {
        List<ArchiveCategoryInfo> categoryInfos = this.archiveCategoryInfoService.selectDeptList(new ArchiveCategoryInfo());
        Iterator<ArchiveCategoryInfo> it = categoryInfos.iterator();
        while (it.hasNext()) {
            ArchiveCategoryInfo d = it.next();
            if (!d.getId().equals(id)) continue;
            it.remove();
        }
        return AjaxResult.success(categoryInfos);
    }

    @GetMapping(value={"/treeselect"})
    public AjaxResult treeselect(ArchiveCategoryInfo archiveCategoryInfo) {
        List<ArchiveCategoryInfo> archiveCategoryInfos = this.archiveCategoryInfoService.selectDeptList(archiveCategoryInfo);
        return AjaxResult.success(this.archiveCategoryInfoService.buildDeptTreeSelect(archiveCategoryInfos));
    }

    @GetMapping(value={"/treeselectAndYear"})
    public AjaxResult treeselectAndYear(ArchiveCategoryInfo archiveCategoryInfo) {
        List<ArchiveCategoryInfo> archiveCategoryInfos = this.archiveCategoryInfoService.selectDeptListAndYear(archiveCategoryInfo);
        return AjaxResult.success(this.archiveCategoryInfoService.buildDeptTreeSelect(archiveCategoryInfos));
    }

    @GetMapping(value={"/listCategoryInfo"})
    public AjaxResult listCategoryInfo(ArchiveCategoryInfo archiveCategoryInfo) {
        List<ArchiveCategoryInfo> archiveCategoryInfos = this.archiveCategoryInfoService.listCategoryInfo(archiveCategoryInfo);
        return AjaxResult.success(archiveCategoryInfos);
    }

    @GetMapping(value={"/treeSonselect"})
    public AjaxResult treeSonselect(ArchiveCategoryInfo archiveCategoryInfo) {
        archiveCategoryInfo = this.archiveCategoryInfoService.getByCode(archiveCategoryInfo);
        List<ArchiveCategoryInfo> archiveCategoryInfos = this.archiveCategoryInfoService.selectListBySon(archiveCategoryInfo);
        return AjaxResult.success(this.archiveCategoryInfoService.buildDeptTreeSelect(archiveCategoryInfos));
    }

    @GetMapping(value={"/listSonselect"})
    public AjaxResult listSonselect(ArchiveCategoryInfo archiveCategoryInfo) {
        archiveCategoryInfo = this.archiveCategoryInfoService.getByCode(archiveCategoryInfo);
        List<ArchiveCategoryInfo> archiveCategoryInfos = this.archiveCategoryInfoService.selectListBySon(archiveCategoryInfo);
        return AjaxResult.success(archiveCategoryInfos);
    }
}

