/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntPredicate;
import javax.net.ssl.SSLSession;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.AbstractListenerReadPublisher;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.DefaultSslInfo;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.http.server.reactive.UndertowHeadersAdapter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.xnio.channels.StreamSourceChannel;
import reactor.core.publisher.Flux;

class UndertowServerHttpRequest
extends AbstractServerHttpRequest {
    private final HttpServerExchange exchange;
    private final RequestBodyPublisher body;

    public UndertowServerHttpRequest(HttpServerExchange exchange2, DataBufferFactory bufferFactory) throws URISyntaxException {
        super(UndertowServerHttpRequest.initUri(exchange2), "", UndertowServerHttpRequest.initHeaders(exchange2));
        this.exchange = exchange2;
        this.body = new RequestBodyPublisher(exchange2, bufferFactory);
        this.body.registerListeners(exchange2);
    }

    private static URI initUri(HttpServerExchange exchange2) throws URISyntaxException {
        Assert.notNull((Object)exchange2, (String)"HttpServerExchange is required");
        String requestURL = exchange2.getRequestURL();
        String query = exchange2.getQueryString();
        String requestUriAndQuery = StringUtils.hasLength((String)query) ? requestURL + "?" + query : requestURL;
        return new URI(requestUriAndQuery);
    }

    private static HttpHeaders initHeaders(HttpServerExchange exchange2) {
        return new HttpHeaders(new UndertowHeadersAdapter(exchange2.getRequestHeaders()));
    }

    @Override
    public String getMethodValue() {
        return this.exchange.getRequestMethod().toString();
    }

    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        for (String name : this.exchange.getRequestCookies().keySet()) {
            Cookie cookie = (Cookie)this.exchange.getRequestCookies().get(name);
            HttpCookie httpCookie = new HttpCookie(name, cookie.getValue());
            cookies.add((Object)name, (Object)httpCookie);
        }
        return cookies;
    }

    @Override
    @Nullable
    public InetSocketAddress getRemoteAddress() {
        return this.exchange.getSourceAddress();
    }

    @Override
    @Nullable
    protected SslInfo initSslInfo() {
        SSLSession session = this.exchange.getConnection().getSslSession();
        if (session != null) {
            return new DefaultSslInfo(session);
        }
        return null;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return Flux.from((Publisher)this.body);
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.exchange;
    }

    @Override
    protected String initId() {
        return ObjectUtils.getIdentityHexString((Object)this.exchange.getConnection());
    }

    private static class UndertowDataBuffer
    implements PooledDataBuffer {
        private final DataBuffer dataBuffer;
        private final PooledByteBuffer pooledByteBuffer;
        private final AtomicInteger refCount;

        public UndertowDataBuffer(DataBuffer dataBuffer, PooledByteBuffer pooledByteBuffer) {
            this.dataBuffer = dataBuffer;
            this.pooledByteBuffer = pooledByteBuffer;
            this.refCount = new AtomicInteger(1);
        }

        private UndertowDataBuffer(DataBuffer dataBuffer, PooledByteBuffer pooledByteBuffer, AtomicInteger refCount) {
            this.refCount = refCount;
            this.dataBuffer = dataBuffer;
            this.pooledByteBuffer = pooledByteBuffer;
        }

        public boolean isAllocated() {
            return this.refCount.get() > 0;
        }

        public PooledDataBuffer retain() {
            this.refCount.incrementAndGet();
            DataBufferUtils.retain((DataBuffer)this.dataBuffer);
            return this;
        }

        public boolean release() {
            int refCount = this.refCount.decrementAndGet();
            if (refCount == 0) {
                try {
                    boolean bl = DataBufferUtils.release((DataBuffer)this.dataBuffer);
                    return bl;
                }
                finally {
                    this.pooledByteBuffer.close();
                }
            }
            return false;
        }

        public DataBufferFactory factory() {
            return this.dataBuffer.factory();
        }

        public int indexOf(IntPredicate predicate, int fromIndex) {
            return this.dataBuffer.indexOf(predicate, fromIndex);
        }

        public int lastIndexOf(IntPredicate predicate, int fromIndex) {
            return this.dataBuffer.lastIndexOf(predicate, fromIndex);
        }

        public int readableByteCount() {
            return this.dataBuffer.readableByteCount();
        }

        public int writableByteCount() {
            return this.dataBuffer.writableByteCount();
        }

        public int readPosition() {
            return this.dataBuffer.readPosition();
        }

        public DataBuffer readPosition(int readPosition) {
            return this.dataBuffer.readPosition(readPosition);
        }

        public int writePosition() {
            return this.dataBuffer.writePosition();
        }

        public DataBuffer writePosition(int writePosition) {
            this.dataBuffer.writePosition(writePosition);
            return this;
        }

        public int capacity() {
            return this.dataBuffer.capacity();
        }

        public DataBuffer capacity(int newCapacity) {
            this.dataBuffer.capacity(newCapacity);
            return this;
        }

        public DataBuffer ensureCapacity(int capacity) {
            this.dataBuffer.ensureCapacity(capacity);
            return this;
        }

        public byte getByte(int index) {
            return this.dataBuffer.getByte(index);
        }

        public byte read() {
            return this.dataBuffer.read();
        }

        public DataBuffer read(byte[] destination) {
            this.dataBuffer.read(destination);
            return this;
        }

        public DataBuffer read(byte[] destination, int offset, int length) {
            this.dataBuffer.read(destination, offset, length);
            return this;
        }

        public DataBuffer write(byte b) {
            this.dataBuffer.write(b);
            return this;
        }

        public DataBuffer write(byte[] source) {
            this.dataBuffer.write(source);
            return this;
        }

        public DataBuffer write(byte[] source, int offset, int length) {
            this.dataBuffer.write(source, offset, length);
            return this;
        }

        public DataBuffer write(DataBuffer ... buffers) {
            this.dataBuffer.write(buffers);
            return this;
        }

        public DataBuffer write(ByteBuffer ... byteBuffers) {
            this.dataBuffer.write(byteBuffers);
            return this;
        }

        public DataBuffer write(CharSequence charSequence, Charset charset) {
            this.dataBuffer.write(charSequence, charset);
            return this;
        }

        public DataBuffer slice(int index, int length) {
            DataBuffer slice = this.dataBuffer.slice(index, length);
            return new UndertowDataBuffer(slice, this.pooledByteBuffer, this.refCount);
        }

        public ByteBuffer asByteBuffer() {
            return this.dataBuffer.asByteBuffer();
        }

        public ByteBuffer asByteBuffer(int index, int length) {
            return this.dataBuffer.asByteBuffer(index, length);
        }

        public InputStream asInputStream() {
            return this.dataBuffer.asInputStream();
        }

        public InputStream asInputStream(boolean releaseOnClose) {
            return this.dataBuffer.asInputStream(releaseOnClose);
        }

        public OutputStream asOutputStream() {
            return this.dataBuffer.asOutputStream();
        }
    }

    private class RequestBodyPublisher
    extends AbstractListenerReadPublisher<DataBuffer> {
        private final StreamSourceChannel channel;
        private final DataBufferFactory bufferFactory;
        private final ByteBufferPool byteBufferPool;

        public RequestBodyPublisher(HttpServerExchange exchange2, DataBufferFactory bufferFactory) {
            super(UndertowServerHttpRequest.this.getLogPrefix());
            this.channel = exchange2.getRequestChannel();
            this.bufferFactory = bufferFactory;
            this.byteBufferPool = exchange2.getConnection().getByteBufferPool();
        }

        private void registerListeners(HttpServerExchange exchange2) {
            exchange2.addExchangeCompleteListener((ex, next) -> {
                this.onAllDataRead();
                next.proceed();
            });
            this.channel.getReadSetter().set(c -> this.onDataAvailable());
            this.channel.getCloseSetter().set(c -> this.onAllDataRead());
            this.channel.resumeReads();
        }

        @Override
        protected void checkOnDataAvailable() {
            this.channel.resumeReads();
            this.onDataAvailable();
        }

        @Override
        protected void readingPaused() {
            this.channel.suspendReads();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        protected DataBuffer read() throws IOException {
            PooledByteBuffer pooledByteBuffer = this.byteBufferPool.allocate();
            boolean release = true;
            try {
                ByteBuffer byteBuffer = pooledByteBuffer.getBuffer();
                int read = this.channel.read(byteBuffer);
                if (rsReadLogger.isTraceEnabled()) {
                    rsReadLogger.trace((Object)(this.getLogPrefix() + "Read " + read + (read != -1 ? " bytes" : "")));
                }
                if (read > 0) {
                    byteBuffer.flip();
                    DataBuffer dataBuffer = this.bufferFactory.wrap(byteBuffer);
                    release = false;
                    UndertowDataBuffer undertowDataBuffer = new UndertowDataBuffer(dataBuffer, pooledByteBuffer);
                    return undertowDataBuffer;
                }
                if (read == -1) {
                    this.onAllDataRead();
                }
                DataBuffer dataBuffer = null;
                return dataBuffer;
            }
            finally {
                if (release && pooledByteBuffer.isOpen()) {
                    pooledByteBuffer.close();
                }
            }
        }

        @Override
        protected void discardData() {
        }
    }
}

