/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.catalina.realm.DigestCredentialHandlerBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;

public class MessageDigestCredentialHandler
extends DigestCredentialHandlerBase {
    private static final Log log = LogFactory.getLog(MessageDigestCredentialHandler.class);
    public static final int DEFAULT_ITERATIONS = 1;
    private Charset encoding = StandardCharsets.UTF_8;
    private String algorithm = null;

    public String getEncoding() {
        return this.encoding.name();
    }

    public void setEncoding(String encodingName) {
        if (encodingName == null) {
            this.encoding = StandardCharsets.UTF_8;
        } else {
            try {
                this.encoding = B2CConverter.getCharset(encodingName);
            }
            catch (UnsupportedEncodingException e) {
                log.error(sm.getString("mdCredentialHandler.unknownEncoding", encodingName, this.encoding.name()));
            }
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void setAlgorithm(String algorithm) throws NoSuchAlgorithmException {
        ConcurrentMessageDigest.init(algorithm);
        this.algorithm = algorithm;
    }

    @Override
    public boolean matches(String inputCredentials, String storedCredentials) {
        if (inputCredentials == null || storedCredentials == null) {
            return false;
        }
        if (this.getAlgorithm() == null) {
            return storedCredentials.equals(inputCredentials);
        }
        if (storedCredentials.startsWith("{MD5}") || storedCredentials.startsWith("{SHA}")) {
            String base64ServerDigest = storedCredentials.substring(5);
            byte[] userDigest = ConcurrentMessageDigest.digest(this.getAlgorithm(), new byte[][]{inputCredentials.getBytes(StandardCharsets.ISO_8859_1)});
            String base64UserDigest = Base64.encodeBase64String(userDigest);
            return base64UserDigest.equals(base64ServerDigest);
        }
        if (storedCredentials.startsWith("{SSHA}")) {
            String serverDigestPlusSalt = storedCredentials.substring(6);
            byte[] serverDigestPlusSaltBytes = Base64.decodeBase64(serverDigestPlusSalt);
            int digestLength = 20;
            byte[] serverDigestBytes = new byte[20];
            System.arraycopy(serverDigestPlusSaltBytes, 0, serverDigestBytes, 0, 20);
            int saltLength = serverDigestPlusSaltBytes.length - 20;
            byte[] serverSaltBytes = new byte[saltLength];
            System.arraycopy(serverDigestPlusSaltBytes, 20, serverSaltBytes, 0, saltLength);
            byte[] userDigestBytes = ConcurrentMessageDigest.digest(this.getAlgorithm(), inputCredentials.getBytes(StandardCharsets.ISO_8859_1), serverSaltBytes);
            return Arrays.equals(userDigestBytes, serverDigestBytes);
        }
        if (storedCredentials.indexOf(36) > -1) {
            return this.matchesSaltIterationsEncoded(inputCredentials, storedCredentials);
        }
        String userDigest = this.mutate(inputCredentials, null, 1);
        if (userDigest == null) {
            return false;
        }
        return storedCredentials.equalsIgnoreCase(userDigest);
    }

    @Override
    protected String mutate(String inputCredentials, byte[] salt, int iterations) {
        if (this.algorithm == null) {
            return inputCredentials;
        }
        byte[] inputCredentialbytes = inputCredentials.getBytes(this.encoding);
        byte[] userDigest = salt == null ? ConcurrentMessageDigest.digest(this.algorithm, iterations, (byte[][])new byte[][]{inputCredentialbytes}) : ConcurrentMessageDigest.digest(this.algorithm, iterations, (byte[][])new byte[][]{salt, inputCredentialbytes});
        return HexUtils.toHexString(userDigest);
    }

    @Override
    protected int getDefaultIterations() {
        return 1;
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

