/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.core.internal.util.ClassLoading;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.CacheResourceConfigurationParser;
import org.ehcache.xml.CacheServiceConfigurationParser;
import org.ehcache.xml.CoreCacheConfigurationParser;
import org.ehcache.xml.ResourceConfigurationParser;
import org.ehcache.xml.ServiceConfigurationParser;
import org.ehcache.xml.ServiceCreationConfigurationParser;
import org.ehcache.xml.XmlConfiguration;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.model.BaseCacheType;
import org.ehcache.xml.model.CacheDefinition;
import org.ehcache.xml.model.CacheEntryType;
import org.ehcache.xml.model.CacheTemplate;
import org.ehcache.xml.model.CacheTemplateType;
import org.ehcache.xml.model.CacheType;
import org.ehcache.xml.model.ConfigType;
import org.ehcache.xml.model.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConfigurationParser {
    private static final Pattern SYSPROP = Pattern.compile("\\$\\{([^}]+)\\}");
    private static final SchemaFactory XSD_SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static final URL CORE_SCHEMA_URL = XmlConfiguration.class.getResource("/ehcache-core.xsd");
    static final String CORE_SCHEMA_NAMESPACE = "http://www.ehcache.org/v3";
    private static final String CORE_SCHEMA_ROOT_ELEMENT = "config";
    static final String CORE_SCHEMA_JAXB_MODEL_PACKAGE = ConfigType.class.getPackage().getName();
    static final CoreCacheConfigurationParser CORE_CACHE_CONFIGURATION_PARSER = new CoreCacheConfigurationParser();
    private final Schema schema;
    private final JAXBContext jaxbContext = JAXBContext.newInstance((String)CORE_SCHEMA_JAXB_MODEL_PACKAGE, (ClassLoader)ConfigType.class.getClassLoader());
    private final ServiceCreationConfigurationParser serviceCreationConfigurationParser;
    private final ServiceConfigurationParser serviceConfigurationParser;
    private final ResourceConfigurationParser resourceConfigurationParser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Schema newSchema(Source[] schemas) throws SAXException {
        SchemaFactory schemaFactory = XSD_SCHEMA_FACTORY;
        synchronized (schemaFactory) {
            return XSD_SCHEMA_FACTORY.newSchema(schemas);
        }
    }

    static String replaceProperties(String originalValue, Properties properties) {
        Matcher matcher = SYSPROP.matcher(originalValue);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String property = matcher.group(1);
            String value = properties.getProperty(property);
            if (value == null) {
                throw new IllegalStateException(String.format("Replacement for ${%s} not found!", property));
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(sb);
        String resolvedValue = sb.toString();
        return resolvedValue.equals(originalValue) ? null : resolvedValue;
    }

    private static <T> T retrieveChild(T val1, T val2) {
        if (val1 == null) {
            return val2;
        }
        if (val1.getClass().isInstance(val2)) {
            return val2;
        }
        return val1;
    }

    public ConfigurationParser() throws IOException, SAXException, JAXBException, ParserConfigurationException {
        ArrayList<Source> schemaSources = new ArrayList<Source>();
        schemaSources.add(new StreamSource(CORE_SCHEMA_URL.openStream()));
        HashMap xmlParserMap = new HashMap();
        for (CacheManagerServiceConfigurationParser cacheManagerServiceConfigurationParser : ClassLoading.libraryServiceLoaderFor(CacheManagerServiceConfigurationParser.class)) {
            xmlParserMap.compute(cacheManagerServiceConfigurationParser.getServiceType(), (k, parserVal) -> ConfigurationParser.retrieveChild(parserVal, cacheManagerServiceConfigurationParser));
        }
        for (CacheManagerServiceConfigurationParser<Object> cacheManagerServiceConfigurationParser : xmlParserMap.values()) {
            schemaSources.add(cacheManagerServiceConfigurationParser.getXmlSchema());
        }
        this.serviceCreationConfigurationParser = new ServiceCreationConfigurationParser(xmlParserMap);
        HashMap cacheXmlParserMap = new HashMap();
        for (CacheServiceConfigurationParser cacheServiceConfigurationParser : ClassLoading.libraryServiceLoaderFor(CacheServiceConfigurationParser.class)) {
            cacheXmlParserMap.compute(cacheServiceConfigurationParser.getServiceType(), (k, parserVal) -> ConfigurationParser.retrieveChild(parserVal, cacheServiceConfigurationParser));
        }
        for (CacheServiceConfigurationParser cacheServiceConfigurationParser : cacheXmlParserMap.values()) {
            schemaSources.add(cacheServiceConfigurationParser.getXmlSchema());
        }
        this.serviceConfigurationParser = new ServiceConfigurationParser(cacheXmlParserMap);
        HashMap<Class, CacheResourceConfigurationParser> hashMap = new HashMap<Class, CacheResourceConfigurationParser>();
        for (CacheResourceConfigurationParser parser : ClassLoading.libraryServiceLoaderFor(CacheResourceConfigurationParser.class)) {
            Set<Class<? extends ResourcePool>> resourcePoolSet = parser.getResourceTypes();
            for (Class<? extends ResourcePool> x : resourcePoolSet) {
                hashMap.compute(x, (k, parserVal) -> ConfigurationParser.retrieveChild(parserVal, parser));
            }
        }
        HashSet<CacheResourceConfigurationParser> hashSet = new HashSet<CacheResourceConfigurationParser>();
        for (CacheResourceConfigurationParser parser : hashMap.values()) {
            if (hashSet.contains(parser)) continue;
            hashSet.add(parser);
            schemaSources.add(parser.getXmlSchema());
        }
        this.schema = ConfigurationParser.newSchema(schemaSources.toArray(new Source[schemaSources.size()]));
        this.resourceConfigurationParser = new ResourceConfigurationParser(this.schema, hashSet);
    }

    ResourceConfigurationParser getResourceConfigurationParser() {
        return this.resourceConfigurationParser;
    }

    public XmlConfigurationWrapper parseConfiguration(String uri, ClassLoader classLoader, Map<String, ClassLoader> cacheClassLoaders) throws IOException, SAXException, JAXBException, ParserConfigurationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ConfigType configType = this.parseXml(uri);
        ConfigurationBuilder managerBuilder = ConfigurationBuilder.newConfigurationBuilder().withClassLoader(classLoader);
        managerBuilder = this.serviceCreationConfigurationParser.parseServiceCreationConfiguration(configType, classLoader, managerBuilder);
        for (CacheDefinition cacheDefinition : ConfigurationParser.getCacheElements(configType)) {
            String alias = cacheDefinition.id();
            if (managerBuilder.containsCache(alias)) {
                throw new XmlConfigurationException("Two caches defined with the same alias: " + alias);
            }
            ClassLoader cacheClassLoader = cacheClassLoaders.get(alias);
            boolean classLoaderConfigured = false;
            if (cacheClassLoader != null) {
                classLoaderConfigured = true;
            }
            if (cacheClassLoader == null) {
                cacheClassLoader = classLoader != null ? classLoader : ClassLoading.getDefaultClassLoader();
            }
            Class<?> keyType = XmlConfiguration.getClassForName(cacheDefinition.keyType(), cacheClassLoader);
            Class<?> valueType = XmlConfiguration.getClassForName(cacheDefinition.valueType(), cacheClassLoader);
            ResourcePools resourcePools = this.resourceConfigurationParser.parseResourceConfiguration(cacheDefinition, ResourcePoolsBuilder.newResourcePoolsBuilder());
            CacheConfigurationBuilder<?, ?> cacheBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, resourcePools);
            if (classLoaderConfigured) {
                cacheBuilder = cacheBuilder.withClassLoader(cacheClassLoader);
            }
            cacheBuilder = this.parseServiceConfigurations(cacheBuilder, cacheClassLoader, cacheDefinition);
            managerBuilder = managerBuilder.addCache(alias, (CacheConfiguration<?, ?>)cacheBuilder.build());
        }
        Map<String, CacheTemplate> templates = ConfigurationParser.getTemplates(configType);
        return new XmlConfigurationWrapper(managerBuilder.build(), templates);
    }

    <K, V> CacheConfigurationBuilder<K, V> parseServiceConfigurations(CacheConfigurationBuilder<K, V> cacheBuilder, ClassLoader cacheClassLoader, CacheTemplate cacheDefinition) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        cacheBuilder = CORE_CACHE_CONFIGURATION_PARSER.parseConfiguration(cacheDefinition, cacheClassLoader, cacheBuilder);
        return this.serviceConfigurationParser.parseConfiguration(cacheDefinition, cacheClassLoader, cacheBuilder);
    }

    public ConfigType parseXml(String uri) throws ParserConfigurationException, IOException, SAXException, JAXBException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setSchema(this.schema);
        DocumentBuilder domBuilder = factory.newDocumentBuilder();
        domBuilder.setErrorHandler(new FatalErrorHandler());
        Document document = domBuilder.parse(uri);
        Element dom = document.getDocumentElement();
        this.substituteSystemProperties(dom);
        if (!CORE_SCHEMA_ROOT_ELEMENT.equals(dom.getLocalName()) || !CORE_SCHEMA_NAMESPACE.equals(dom.getNamespaceURI())) {
            throw new XmlConfigurationException("Expecting {http://www.ehcache.org/v3}config element; found {" + dom.getNamespaceURI() + "}" + dom.getLocalName());
        }
        Class<ConfigType> configTypeClass = ConfigType.class;
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        return (ConfigType)unmarshaller.unmarshal((Node)dom, configTypeClass).getValue();
    }

    private void substituteSystemProperties(Element dom) {
        Properties properties = System.getProperties();
        Stack<NodeList> nodeLists = new Stack<NodeList>();
        nodeLists.push(dom.getChildNodes());
        while (!nodeLists.isEmpty()) {
            NodeList nodeList = (NodeList)nodeLists.pop();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String newValue;
                NamedNodeMap attributes;
                Node currentNode = nodeList.item(i);
                if (currentNode.hasChildNodes()) {
                    nodeLists.push(currentNode.getChildNodes());
                }
                if ((attributes = currentNode.getAttributes()) != null) {
                    for (int j = 0; j < attributes.getLength(); ++j) {
                        Node attributeNode = attributes.item(j);
                        String newValue2 = ConfigurationParser.replaceProperties(attributeNode.getNodeValue(), properties);
                        if (newValue2 == null) continue;
                        attributeNode.setNodeValue(newValue2);
                    }
                }
                if (currentNode.getNodeType() != 3 || (newValue = ConfigurationParser.replaceProperties(currentNode.getNodeValue(), properties)) == null) continue;
                currentNode.setNodeValue(newValue);
            }
        }
    }

    public static Iterable<CacheDefinition> getCacheElements(ConfigType configType) {
        ArrayList<CacheDefinition> cacheCfgs = new ArrayList<CacheDefinition>();
        List<BaseCacheType> cacheOrCacheTemplate = configType.getCacheOrCacheTemplate();
        for (BaseCacheType baseCacheType : cacheOrCacheTemplate) {
            if (!(baseCacheType instanceof CacheType)) continue;
            CacheType cacheType = (CacheType)baseCacheType;
            BaseCacheType[] sources = cacheType.getUsesTemplate() != null ? new BaseCacheType[]{cacheType, (BaseCacheType)cacheType.getUsesTemplate()} : new BaseCacheType[]{cacheType};
            cacheCfgs.add(new CacheDefinition(cacheType.getAlias(), sources));
        }
        return Collections.unmodifiableList(cacheCfgs);
    }

    public static Map<String, CacheTemplate> getTemplates(ConfigType configType) {
        HashMap<String, CacheTemplate.Impl> templates = new HashMap<String, CacheTemplate.Impl>();
        List<BaseCacheType> cacheOrCacheTemplate = configType.getCacheOrCacheTemplate();
        for (BaseCacheType baseCacheType : cacheOrCacheTemplate) {
            if (!(baseCacheType instanceof CacheTemplateType)) continue;
            CacheTemplateType cacheTemplate = (CacheTemplateType)baseCacheType;
            templates.put(cacheTemplate.getName(), new CacheTemplate.Impl(cacheTemplate.getName(), cacheTemplate));
        }
        return Collections.unmodifiableMap(templates);
    }

    public String unparseConfiguration(Configuration configuration) throws JAXBException {
        ConfigType configType = new ConfigType();
        this.serviceCreationConfigurationParser.unparseServiceCreationConfiguration(configuration, configType);
        for (Map.Entry<String, CacheConfiguration<?, ?>> cacheConfigurationEntry : configuration.getCacheConfigurations().entrySet()) {
            CacheConfiguration<?, ?> cacheConfiguration = cacheConfigurationEntry.getValue();
            CacheType cacheType = new CacheType().withAlias(cacheConfigurationEntry.getKey()).withKeyType(new CacheEntryType().withValue(cacheConfiguration.getKeyType().getName())).withValueType(new CacheEntryType().withValue(cacheConfiguration.getValueType().getName()));
            this.resourceConfigurationParser.unparseResourceConfiguration(cacheConfiguration.getResourcePools(), cacheType);
            CORE_CACHE_CONFIGURATION_PARSER.unparseConfiguration(cacheConfiguration, cacheType);
            this.serviceConfigurationParser.unparseServiceConfiguration(cacheConfiguration, cacheType);
            configType.withCacheOrCacheTemplate(cacheType);
        }
        StringWriter writer = new StringWriter();
        JAXBElement<ConfigType> root = new ObjectFactory().createConfig(configType);
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setSchema(this.schema);
        marshaller.marshal(root, (Writer)writer);
        return writer.toString();
    }

    public static class XmlConfigurationWrapper {
        private final Configuration configuration;
        private final Map<String, CacheTemplate> templates;

        public XmlConfigurationWrapper(Configuration configuration, Map<String, CacheTemplate> templates) {
            this.configuration = configuration;
            this.templates = templates;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public Map<String, CacheTemplate> getTemplates() {
            return this.templates;
        }
    }

    static class FatalErrorHandler
    implements ErrorHandler {
        FatalErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

